% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_grassmann.R
\name{grassmann.utest}
\alias{grassmann.utest}
\title{Test of Uniformity on Grassmann Manifold}
\usage{
grassmann.utest(grobj, method = c("Bing", "BingM"))
}
\arguments{
\item{grobj}{a S3 \code{"riemdata"} class of Grassmann-valued data.}

\item{method}{(case-insensitive) name of the test method containing \describe{
\item{\code{"Bing"}}{Bingham statistic.}
\item{\code{"BingM"}}{modified Bingham statistic with better order of error.}
}}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given the data on Grassmann manifold \eqn{Gr(k,p)}, it tests whether the 
data is distributed uniformly.
}
\examples{
#-------------------------------------------------------------------
#   Compare Bingham's original and modified versions of the test
# 
# Test 1. sample uniformly from Gr(2,4)
# Test 2. use perturbed principal components from 'iris' data in R^4
#         which is concentrated around a point to reject H0.
#-------------------------------------------------------------------
## Data Generation
#  1. uniform data
myobj1 = grassmann.runif(n=100, k=2, p=4)

#  2. perturbed principal components
data(iris)
irdat = list()
for (n in 1:100){
   tmpdata    = iris[1:50,1:4] + matrix(rnorm(50*4,sd=0.5),ncol=4)
   irdat[[n]] = eigen(cov(tmpdata))$vectors[,1:2]
}
myobj2 = wrap.grassmann(irdat)

## Test 1 : uniform data
grassmann.utest(myobj1, method="Bing")
grassmann.utest(myobj1, method="BingM")

## Tests : iris data
grassmann.utest(myobj2, method="bINg")   # method names are 
grassmann.utest(myobj2, method="BiNgM")  # CASE - INSENSITIVE !

}
\references{
\insertRef{chikuse_statistics_2003}{Riemann}

\insertRef{mardia_directional_1999}{Riemann}
}
\seealso{
\code{\link{wrap.grassmann}}
}
\concept{grassmann}
