% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_forestry.R
\name{predict-adaptiveForestry}
\alias{predict-adaptiveForestry}
\alias{predict.adaptiveForestry}
\title{predict-adaptiveForestry}
\usage{
\method{predict}{adaptiveForestry}(
  object,
  newdata,
  aggregation = "average",
  seed = as.integer(runif(1) * 10000),
  nthread = 0,
  exact = NULL,
  weighting = NULL,
  ...
)
}
\arguments{
\item{object}{An `adaptiveForestry` object.}

\item{newdata}{A data frame of testing predictors.}

\item{aggregation}{How the individual tree predictions are aggregated:
`average` returns the mean of all trees in the forest; `weightMatrix`
returns a list consisting of "weightMatrix", the adaptive nearest neighbor
weights used to construct the predictions; "terminalNodes", a matrix where
the ith entry of the jth column is the index of the leaf node to which the
ith observation is assigned in the jth tree; and "sparse", a matrix
where the ith entry in the jth column is 1 if the ith observation in
feature.new is assigned to the jth leaf and 0 otherwise. In each tree the
leaves are indexed using a depth first ordering, and, in the "sparse"
representation, the first leaf in the second tree has column index one more than
the number of leaves in the first tree and so on. So, for example, if the
first tree has 5 leaves, the sixth column of the "sparse" matrix corresponds
to the first leaf in the second tree.}

\item{seed}{random seed}

\item{nthread}{The number of threads with which to run the predictions with.
This will default to the number of threads with which the forest was trained
with.}

\item{exact}{This specifies whether the forest predictions should be aggregated
in a reproducible ordering. Due to the non-associativity of floating point
addition, when we predict in parallel, predictions will be aggregated in
varied orders as different threads finish at different times.
By default, exact is TRUE unless N > 100,000 or a custom aggregation
function is used.}

\item{weighting}{This should be a number between 0 and 1 indicating the
weight with which to use the predictions of the two forests. This
specifically specifies the weight given to the second.forest object. The
predictions are given by weighting * predict(object@second.forest) +
(1-weighting) * predict(object@first.forest).
Defaults to NULL, and in this case, weighting = ntree.second / (ntree.first + ntree.second).}

\item{...}{additional arguments.}
}
\value{
A vector of predicted responses.
}
\description{
Return the prediction from the forest.
}
