/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.text;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.CTTextBodyProperties;
import org.docx4j.dml.CTTextListStyle;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.text.Paragraph;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.jaxb.Context;
import org.pptx4j.pml.Shape;

public class ParagraphSet
extends DocComponent
implements HTML4R,
PPTX4R,
DOCX4R {
    private LinkedHashMap<Integer, Paragraph> parList;
    private String tag;
    private static String SAMPLE_SHAPE_START = "<p:sp xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"><p:nvSpPr><p:cNvPr id=\"${id_shape}\" name=\"Title ${title_shape}\" /><p:cNvSpPr><a:spLocks noGrp=\"${noGrp}\" /></p:cNvSpPr><p:nvPr><p:ph idx=\"${idx}\"/></p:nvPr></p:nvSpPr><p:spPr><a:xfrm><a:off x=\"${offx}\" y=\"${offy}\"/><a:ext cx=\"${cx}\" cy=\"${cy}\"/></a:xfrm></p:spPr><p:txBody><a:bodyPr /><a:lstStyle />";
    private static String SAMPLE_SHAPE_END = "</p:txBody></p:sp>";

    public ParagraphSet(ParProperties parProp) {
        this.setParProperties(parProp);
        this.parList = new LinkedHashMap();
        this.setParProperties(parProp);
        this.setTag("div");
    }

    public void addParagraph(Paragraph par) {
        this.parList.put(this.size(), par);
    }

    public int size() {
        return this.parList.size();
    }

    public Paragraph getLast() {
        return this.parList.get(this.size() - 1);
    }

    public void setTag(String t) {
        this.tag = t;
    }

    public void setTextProperties(TextProperties tp) {
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                this.parList.get(i).setTextProperties(tp);
                ++i;
            }
        }
    }

    public String toString() {
        String out = "";
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                out = String.valueOf(out) + this.parList.get(i).toString();
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getHTML() {
        if (this.size() < 1) {
            return "";
        }
        LinkedHashMap<String, String> ppr = this.getParProperties().get_html_pp();
        String out = "";
        String elt_tag_beg = "<p>";
        String elt_tag_end = "</p>";
        if (this.tag.equals("ul") || this.tag.equals("ol")) {
            elt_tag_beg = "<li>";
            elt_tag_end = "</p>";
        } else if (this.tag.equals("pre")) {
            elt_tag_beg = "";
            elt_tag_end = "";
        }
        if (!this.tag.equals("pre")) {
            out = "<" + this.tag + " style=\"";
            String styleStr = Format.getJSString(ppr);
            out = String.valueOf(out) + styleStr + "\">";
        } else {
            out = "<" + this.tag + ">";
        }
        int i = 0;
        while (i < this.size()) {
            out = String.valueOf(out) + elt_tag_beg + this.parList.get(i).getHTML() + elt_tag_end;
            ++i;
        }
        out = String.valueOf(out) + "</" + this.tag + ">";
        return out;
    }

    public Shape get_pptx_elt() throws Exception {
        if (!this.validatePPTXComponent()) {
            throw new Exception("class ParagraphSet: elements need to be set...");
        }
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("id_shape", String.valueOf(this.shape_id));
        mappings.put("title_shape", "Texts" + this.shape_id);
        mappings.put("idx", String.valueOf(this.unique_id));
        mappings.put("noGrp", "1");
        mappings.put("cx", "" + this.getCx());
        mappings.put("cy", "" + this.getCy());
        mappings.put("offx", "" + this.getOffx());
        mappings.put("offy", "" + this.getOffy());
        Shape o = (Shape)XmlUtils.unmarshallFromTemplate((String)(String.valueOf(SAMPLE_SHAPE_START) + "<a:p/>" + SAMPLE_SHAPE_END), mappings, (JAXBContext)Context.jcPML, Shape.class);
        o.setTxBody(this.get_pptx_parset());
        return o;
    }

    public CTTextBody get_pptx_parset() throws Exception {
        CTTextParagraphProperties rpr = this.getParProperties().get_pptx_pp();
        Vector<CTTextParagraph> out = new Vector<CTTextParagraph>();
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                CTTextParagraph temp = this.parList.get(i).get_pptx_par();
                temp.setPPr(rpr);
                out.add(temp);
                ++i;
            }
        }
        CTTextBody tb = new CTTextBody();
        CTTextBodyProperties pp = new CTTextBodyProperties();
        CTTextListStyle ls = new CTTextListStyle();
        tb.setBodyPr(pp);
        tb.setLstStyle(ls);
        tb.getP().addAll(out);
        return tb;
    }

    @Override
    public boolean validateDOCXComponent() {
        return this.getPPr() != null;
    }

    @Override
    public Vector<P> get_docx_elt() throws Exception {
        Vector<P> out = new Vector<P>();
        if (!this.validateDOCXComponent()) {
            throw new Exception("class ParagraphSet: elements need to be set...");
        }
        PPr rpr = this.getPPr();
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                P temp = this.parList.get(i).get_docx_par();
                temp.setPPr(rpr);
                if (i == 1) {
                    this.addBookmark(temp);
                }
                out.add(temp);
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

