/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.pptx4r.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.docx4j.dml.CTPoint2D;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.dml.ObjectFactory;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.lysis.reporters.pptx4r.elements.layouts.LayoutProperties;
import org.lysis.reporters.pptx4r.elements.layouts.ShapeDescription;
import org.lysis.reporters.pptx4r.elements.layouts.SlideLayout;
import org.lysis.reporters.tools.EMU;
import org.pptx4j.pml.Shape;
import org.pptx4j.pml.SldLayout;
import org.pptx4j.pml.SldMaster;

public class DocExplorer {
    public static HashMap<String, LayoutProperties> browseLayouts(PresentationMLPackage basedoc) throws InvalidFormatException {
        HashMap<String, LayoutProperties> layoutDescriptionList = new HashMap<String, LayoutProperties>();
        for (Map.Entry en : basedoc.getParts().getParts().entrySet()) {
            if (!((Part)en.getValue()).getContentType().equals("application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml")) continue;
            SlideLayoutPart layoutPart = (SlideLayoutPart)basedoc.getParts().getParts().get(new PartName(((PartName)en.getKey()).getName()));
            Vector<ShapeDescription> shapesProperties = new Vector<ShapeDescription>();
            String lpName = ((SldLayout)layoutPart.getJaxbElement()).getCSld().getName();
            String lpKey = ((PartName)en.getKey()).getName();
            List slidesSet = ((SldLayout)layoutPart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
            for (Object element : slidesSet) {
                if (!element.getClass().equals(Shape.class)) continue;
                Shape s = (Shape)element;
                shapesProperties.add(new ShapeDescription(s));
            }
            LayoutProperties lp = new LayoutProperties(lpName, lpKey, shapesProperties);
            layoutDescriptionList.put(lpName, lp);
        }
        return layoutDescriptionList;
    }

    public static HashMap<Integer, ShapeDescription> browseMasterLayout(PresentationMLPackage basedoc) throws InvalidFormatException {
        HashMap<Integer, ShapeDescription> out = new HashMap<Integer, ShapeDescription>();
        for (Map.Entry en : basedoc.getParts().getParts().entrySet()) {
            if (!((Part)en.getValue()).getContentType().equals("application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml")) continue;
            SlideMasterPart layoutPart = (SlideMasterPart)basedoc.getParts().getParts().get(new PartName(((PartName)en.getKey()).getName()));
            List slidesSet = ((SldMaster)layoutPart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
            for (Object element : slidesSet) {
                if (!element.getClass().equals(Shape.class)) continue;
                Shape s = (Shape)element;
                ShapeDescription sd = new ShapeDescription(s);
                if (sd.getShapeType().equals("dt")) {
                    out.put(SlideLayout.DATE, sd);
                    continue;
                }
                if (sd.getShapeType().equals("title")) {
                    out.put(SlideLayout.TITLE, sd);
                    continue;
                }
                if (sd.getShapeType().equals("ftr")) {
                    out.put(SlideLayout.FOOTER, sd);
                    continue;
                }
                if (!sd.getShapeType().equals("sldNum")) continue;
                out.put(SlideLayout.SLIDENUMBER, sd);
            }
            return out;
        }
        return null;
    }

    public static CTTransform2D getXfrm(double offx, double offy, double width, double height) {
        ObjectFactory dmlFactory = new ObjectFactory();
        CTTransform2D xfrm = dmlFactory.createCTTransform2D();
        CTPositiveSize2D ext = dmlFactory.createCTPositiveSize2D();
        ext.setCx(EMU.getEMUFromInch(width));
        ext.setCy(EMU.getEMUFromInch(height));
        xfrm.setExt(ext);
        CTPoint2D off = dmlFactory.createCTPoint2D();
        xfrm.setOff(off);
        off.setX(EMU.getEMUFromInch(offx));
        off.setY(EMU.getEMUFromInch(offy));
        return xfrm;
    }

    public static int countExistingSlides(PresentationMLPackage basedoc) {
        int id_slide = 0;
        for (Map.Entry en : basedoc.getParts().getParts().entrySet()) {
            if (!((Part)en.getValue()).getContentType().equals("application/vnd.openxmlformats-officedocument.presentationml.slide+xml")) continue;
            ++id_slide;
        }
        return id_slide;
    }

    public static void getZipFiles(String filename, String destinationname) {
        try {
            byte[] buf = new byte[1024];
            ZipInputStream zipinputstream = null;
            zipinputstream = new ZipInputStream(new FileInputStream(filename));
            ZipEntry zipentry = zipinputstream.getNextEntry();
            while (zipentry != null) {
                int n;
                String entryName = String.valueOf(destinationname) + zipentry.getName();
                entryName = entryName.replace('/', File.separatorChar);
                entryName = entryName.replace('\\', File.separatorChar);
                File newFile = new File(entryName);
                if (zipentry.isDirectory()) {
                    if (!newFile.mkdirs()) break;
                    zipentry = zipinputstream.getNextEntry();
                    continue;
                }
                FileOutputStream fileoutputstream = new FileOutputStream(entryName);
                while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                    fileoutputstream.write(buf, 0, n);
                }
                fileoutputstream.close();
                zipinputstream.closeEntry();
                zipentry = zipinputstream.getNextEntry();
            }
            zipinputstream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

