/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.text;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import org.docx4j.XmlUtils;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.text.Paragraph;
import org.lysis.reporters.text.ParagraphSet;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.jaxb.Context;
import org.pptx4j.pml.Shape;

public class RScript
extends DocComponent
implements HTML4R,
PPTX4R,
DOCX4R {
    private LinkedHashMap<Integer, Paragraph> parList;
    private int parIndex;
    private static String SAMPLE_SHAPE_START = "<p:sp xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"><p:nvSpPr><p:cNvPr id=\"${id_shape}\" name=\"Title ${title_shape}\" /><p:cNvSpPr><a:spLocks noGrp=\"${noGrp}\" /></p:cNvSpPr><p:nvPr><p:ph idx=\"${idx}\"/></p:nvPr></p:nvSpPr><p:spPr><a:xfrm><a:off x=\"0\" y=\"0\"/><a:ext cx=\"0\" cy=\"0\"/></a:xfrm></p:spPr><p:txBody><a:bodyPr /><a:lstStyle />";
    private static String SAMPLE_SHAPE_END = "</p:txBody></p:sp>";

    public RScript(ParProperties parProp) {
        this.setParProperties(parProp);
        this.parIndex = 0;
        this.parList = new LinkedHashMap();
    }

    public void addParagraph(Paragraph par) {
        ++this.parIndex;
        this.parList.put(this.parIndex, par);
    }

    public int size() {
        return this.parIndex;
    }

    public Paragraph get(int i) {
        return this.parList.get(i);
    }

    public void setTextProperties(TextProperties tp) {
        if (this.parIndex > 0) {
            int i = 1;
            while (i < this.parIndex + 1) {
                this.parList.get(i).setTextProperties(tp);
                ++i;
            }
        }
    }

    public String toString() {
        String out = "";
        if (this.parIndex > 0) {
            int i = 1;
            while (i < this.parIndex + 1) {
                out = String.valueOf(out) + this.parList.get(i).toString();
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getHTML() {
        String out = "<pre>";
        if (this.parIndex > 0) {
            int i = 1;
            while (i < this.parIndex + 1) {
                Paragraph p = this.parList.get(i);
                p.setVanilla();
                out = String.valueOf(out) + this.parList.get(i).getHTML() + "\n";
                ++i;
            }
        }
        out = String.valueOf(out) + "</pre>";
        return out;
    }

    public Shape get_pptx_elt() throws Exception {
        if (!this.validatePPTXComponent()) {
            throw new Exception("class RScript: elements need to be set...");
        }
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("id_shape", String.valueOf(this.shape_id));
        mappings.put("title_shape", "Texts" + this.shape_id);
        mappings.put("idx", String.valueOf(this.unique_id));
        mappings.put("noGrp", "1");
        Shape o = (Shape)XmlUtils.unmarshallFromTemplate((String)(String.valueOf(SAMPLE_SHAPE_START) + "<a:p/>" + SAMPLE_SHAPE_END), mappings, (JAXBContext)Context.jcPML, Shape.class);
        ParagraphSet temp = new ParagraphSet(this.getParProperties());
        int i = 1;
        while (i <= this.size()) {
            temp.addParagraph(this.get(i));
            ++i;
        }
        o.setTxBody(temp.get_pptx_parset());
        return o;
    }

    @Override
    public Vector<P> get_docx_elt() throws Exception {
        if (!this.validateDOCXComponent()) {
            throw new Exception("class RScript: elements need to be set...");
        }
        PPr rpr = this.getParProperties().get_docx_pp();
        Vector<P> out = new Vector<P>();
        if (this.parIndex > 0) {
            int i = 1;
            while (i < this.parIndex + 1) {
                P temp = this.parList.get(i).get_docx_par();
                if (i == 1) {
                    this.addBookmark(temp);
                }
                temp.setPPr(rpr);
                out.add(temp);
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

