% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ReadBib.R
\name{ReadBib}
\alias{ReadBib}
\title{BibLaTeX/BibTeX .bib file parser}
\usage{
ReadBib(file, .Encoding = "UTF-8", header = if (length(preamble))
  paste(preamble, sep = "\\n") else "", footer = "",
  check = BibOptions()$check.entries)
}
\arguments{
\item{file}{string; bib file to parse.}

\item{.Encoding}{encoding}

\item{header}{header of the citation list. By default this is made from the Preamble entries found in the bib file.}

\item{footer}{footer of the citation list.}

\item{check}{\dQuote{error}, \dQuote{warn}, or logical \code{FALSE}.  What action should be taken if an entry is
missing required fields?  \code{FALSE} means no checking is done, \dQuote{warn} means entry is added with an error.
\dQuote{error} means the entry will not be added.  See \code{\link{BibOptions}}.}
}
\description{
Parser for bibliography databases in the bib format containing either BibLaTeX or BibTeX entries.
}
\examples{
file.name <- system.file("Bib", "RJC.bib", package="RefManageR")
bib <- ReadBib(file.name)
}
\author{
McLean, M. W., based on code in \code{bibtex} package by Francois, R.
}
\seealso{
\code{\link{read.bib}} in package \code{bibtex}
}

