% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L.record.R
\name{L.record}
\alias{L.record}
\title{Record Times}
\usage{
L.record(XM_T, record = c("upper", "lower"))
}
\arguments{
\item{XM_T}{A numeric vector, matrix (or data frame).}

\item{record}{A character string indicating the type of record to be 
calculated, "upper" or "lower".}
}
\value{
If \code{XM_T} is a vector, the function returns a column matrix 
  containing the record times. If \code{XM_T} is a matrix, the function 
  returns a list where each element is a vector indicating the record times 
  of the corresponding \code{XM_T} column.
}
\description{
This function calculates the times (positions in the vector) 
  where records occur.
}
\details{
If \code{XM_T} is a matrix, the approach to obtain record times is 
  applied to each column of the matrix. 
  
  Record times can be calculated for both upper and lower records.
}
\examples{
Y1 <- c( 1,  5,  3,  6,  6,  9,  2)
Y2 <- c(10,  5,  3,  6,  6,  9,  2)
Y3 <- c( 5,  7,  3,  6, 19,  2, 20)
Y  <- cbind(Y1, Y2, Y3)

L.record(Y1)
L.record(Y)

}
\seealso{
\code{\link{I.record}}, \code{\link{M.record}},
  \code{\link{N.record}}, \code{\link{P.record}}, \code{\link{Nmean.record}},
  \code{\link{records}}
}
\author{
Jorge Castillo-Mateo
}
