/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieContainer;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieServices;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.util.CDIHelper;
import org.drools.compiler.kie.util.ChangeSetBuilder;
import org.drools.compiler.kie.util.KieJarChangeSet;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.compiler.management.KieContainerMonitor;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.Drools;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.FileLoggerModel;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.MBeansOption;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.logger.KieLoggers;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.ResourceChangeSet;
import org.kie.internal.definition.KnowledgePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieContainerImpl
implements InternalKieContainer {
    private static final Logger log = LoggerFactory.getLogger(KieContainerImpl.class);
    private KieProject kProject;
    private final Map<String, KieBase> kBases = new ConcurrentHashMap<String, KieBase>();
    private final Map<String, KieSession> kSessions = new ConcurrentHashMap<String, KieSession>();
    private final Map<String, StatelessKieSession> statelessKSessions = new ConcurrentHashMap<String, StatelessKieSession>();
    private final KieRepository kr;
    private ReleaseId configuredReleaseId;
    private ReleaseId containerReleaseId;
    private final String containerId;
    private static final ResourceType[] TYPES_TO_BE_INCLUDED = new ResourceType[]{ResourceType.DSL, ResourceType.GDRL};

    @Override
    public KieModule getMainKieModule() {
        return this.kr.getKieModule(this.getReleaseId());
    }

    public KieContainerImpl(KieProject kProject, KieRepository kr) {
        this("impl" + UUID.randomUUID(), kProject, kr);
    }

    public KieContainerImpl(KieProject kProject, KieRepository kr, ReleaseId containerReleaseId) {
        this("impl" + UUID.randomUUID(), kProject, kr, containerReleaseId);
    }

    public KieContainerImpl(String containerId, KieProject kProject, KieRepository kr) {
        this.kr = kr;
        this.kProject = kProject;
        this.containerId = containerId;
        kProject.init();
        this.initMBeans(containerId);
    }

    public KieContainerImpl(String containerId, KieProject kProject, KieRepository kr, ReleaseId containerReleaseId) {
        this(containerId, kProject, kr);
        this.configuredReleaseId = containerReleaseId;
        this.containerReleaseId = containerReleaseId;
    }

    private void initMBeans(String containerId) {
        if (this.isMBeanOptionEnabled()) {
            KieContainerMonitor monitor = new KieContainerMonitor(this);
            ObjectName on = DroolsManagementAgent.createObjectNameBy((String)containerId);
            DroolsManagementAgent.getInstance().registerMBean((Object)this, (Object)monitor, on);
        }
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public ReleaseId getConfiguredReleaseId() {
        return this.configuredReleaseId;
    }

    @Override
    public ReleaseId getResolvedReleaseId() {
        return this.getReleaseId();
    }

    public ReleaseId getReleaseId() {
        return this.kProject.getGAV();
    }

    @Override
    public InputStream getPomAsStream() {
        return this.kProject.getPomAsStream();
    }

    @Override
    public long getCreationTimestamp() {
        return this.kProject.getCreationTimestamp();
    }

    @Override
    public ReleaseId getContainerReleaseId() {
        return this.containerReleaseId != null ? this.containerReleaseId : this.getReleaseId();
    }

    public Results updateToVersion(ReleaseId newReleaseId) {
        this.checkNotClasspathKieProject();
        Results results = this.update(((KieModuleKieProject)this.kProject).getInternalKieModule(), newReleaseId);
        this.containerReleaseId = newReleaseId;
        return results;
    }

    @Override
    public Results updateDependencyToVersion(ReleaseId currentReleaseId, ReleaseId newReleaseId) {
        this.checkNotClasspathKieProject();
        ReleaseId installedReleaseId = this.getReleaseId();
        InternalKieModule currentKM = currentReleaseId.getGroupId().equals(installedReleaseId.getGroupId()) && currentReleaseId.getArtifactId().equals(installedReleaseId.getArtifactId()) ? ((KieModuleKieProject)this.kProject).getInternalKieModule() : (currentReleaseId.equals(newReleaseId) ? (InternalKieModule)((KieRepositoryImpl)this.kr).getOldKieModule(currentReleaseId) : (InternalKieModule)this.kr.getKieModule(currentReleaseId));
        return this.update(currentKM, newReleaseId);
    }

    private void checkNotClasspathKieProject() {
        if (this.kProject instanceof ClasspathKieProject) {
            throw new UnsupportedOperationException("It is not possible to update a classpath container to a new version.");
        }
    }

    private Results update(final InternalKieModule currentKM, final ReleaseId newReleaseId) {
        Map.Entry<String, KieSession> ksession;
        final InternalKieModule newKM = (InternalKieModule)this.kr.getKieModule(newReleaseId);
        ChangeSetBuilder csb = new ChangeSetBuilder();
        final KieJarChangeSet cs = csb.build(currentKM, newKM);
        final List<String> modifiedClasses = this.getModifiedClasses(cs);
        final boolean modifyingUsedClass = this.isModifyingUsedClass(modifiedClasses, this.getClassLoader());
        this.reinitModifiedClasses(newKM, modifiedClasses, this.getClassLoader());
        final List<String> unchangedResources = this.getUnchangedResources(newKM, cs);
        Map<String, KieBaseModel> currentKieBaseModels = ((KieModuleKieProject)this.kProject).updateToModule(newKM);
        final ResultsImpl results = new ResultsImpl();
        ArrayList<String> kbasesToRemove = new ArrayList<String>();
        for (Map.Entry<String, KieBase> kBaseEntry : this.kBases.entrySet()) {
            String kbaseName = kBaseEntry.getKey();
            final KieBaseModel newKieBaseModel = this.kProject.getKieBaseModel(kbaseName);
            final KieBaseModel currentKieBaseModel = currentKieBaseModels.get(kbaseName);
            if (newKieBaseModel == null) {
                kbasesToRemove.add(kbaseName);
                continue;
            }
            final InternalKnowledgeBase kBase = (InternalKnowledgeBase)kBaseEntry.getValue();
            kBase.enqueueModification(new Runnable(){

                @Override
                public void run() {
                    KieContainerImpl.this.updateKBase(kBase, currentKM, newReleaseId, newKM, cs, modifiedClasses, modifyingUsedClass, unchangedResources, results, newKieBaseModel, currentKieBaseModel);
                }
            });
        }
        for (String kbaseToRemove : kbasesToRemove) {
            this.kBases.remove(kbaseToRemove);
        }
        Iterator<Map.Entry<String, KieSession>> it = this.kSessions.entrySet().iterator();
        while (it.hasNext()) {
            ksession = it.next();
            if (this.kProject.getKieSessionModel(ksession.getKey()) != null) continue;
            it.remove();
        }
        it = this.statelessKSessions.entrySet().iterator();
        while (it.hasNext()) {
            ksession = it.next();
            if (this.kProject.getKieSessionModel(ksession.getKey()) != null) continue;
            it.remove();
        }
        return results;
    }

    private void updateKBase(InternalKnowledgeBase kBase, InternalKieModule currentKM, ReleaseId newReleaseId, InternalKieModule newKM, KieJarChangeSet cs, List<String> modifiedClasses, boolean modifyingUsedClass, List<String> unchangedResources, ResultsImpl results, KieBaseModel newKieBaseModel, KieBaseModel currentKieBaseModel) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBase)kBase, (KnowledgeBuilderConfiguration)newKM.getBuilderConfiguration(newKieBaseModel));
        KnowledgeBuilderImpl pkgbuilder = (KnowledgeBuilderImpl)kbuilder;
        CompositeKnowledgeBuilder ckbuilder = kbuilder.batch();
        boolean shouldRebuild = this.applyResourceChanges(currentKM, newKM, cs, modifiedClasses, (KieBase)kBase, newKieBaseModel, pkgbuilder, ckbuilder, modifyingUsedClass);
        for (ResourceChangeSet rcs : cs.getChanges().values()) {
            String resourceName;
            if (rcs.getChangeType() != ChangeType.REMOVED || (resourceName = rcs.getResourceName()).endsWith(".properties") || !this.isFileInKBase(currentKM, currentKieBaseModel, resourceName)) continue;
            pkgbuilder.removeObjectsGeneratedFromResource(currentKM.getResource(resourceName));
        }
        if (shouldRebuild) {
            for (String dslFile : unchangedResources) {
                if (!this.isFileInKBase(newKM, newKieBaseModel, dslFile)) continue;
                newKM.addResourceToCompiler(ckbuilder, newKieBaseModel, dslFile);
            }
            this.rebuildAll(newReleaseId, results, newKM, modifyingUsedClass, newKieBaseModel, pkgbuilder, ckbuilder);
        }
        kBase.setResolvedReleaseId(newReleaseId);
        for (Iterator<Object> iterator : kBase.getWorkingMemories()) {
            iterator.notifyWaitOnRest();
        }
    }

    private List<String> getUnchangedResources(InternalKieModule newKM, KieJarChangeSet cs) {
        ArrayList<String> dslFiles = new ArrayList<String>();
        for (String file : newKM.getFileNames()) {
            if (!this.includeIfUnchanged(file) || cs.contains(file)) continue;
            dslFiles.add(file);
        }
        return dslFiles;
    }

    private boolean includeIfUnchanged(String file) {
        for (ResourceType type : TYPES_TO_BE_INCLUDED) {
            if (!type.matchesExtension(file)) continue;
            return true;
        }
        return false;
    }

    private boolean applyResourceChanges(InternalKieModule currentKM, InternalKieModule newKM, KieJarChangeSet cs, List<String> modifiedClasses, KieBase kBase, KieBaseModel kieBaseModel, KnowledgeBuilderImpl pkgbuilder, CompositeKnowledgeBuilder ckbuilder, boolean modifyingUsedClass) {
        boolean shouldRebuild = modifyingUsedClass;
        if (modifyingUsedClass) {
            this.updateAllResources(currentKM, newKM, kieBaseModel, pkgbuilder, ckbuilder);
        } else {
            shouldRebuild = this.updateResourcesIncrementally(currentKM, newKM, cs, modifiedClasses, kBase, kieBaseModel, pkgbuilder, ckbuilder) > 0;
        }
        return shouldRebuild;
    }

    private boolean isModifyingUsedClass(List<String> modifiedClasses, ClassLoader classLoader) {
        for (String modifiedClass : modifiedClasses) {
            if (!this.isClassInUse(classLoader, ClassUtils.convertResourceToClassName((String)modifiedClass))) continue;
            return true;
        }
        return false;
    }

    private boolean isClassInUse(ClassLoader rootClassLoader, String className) {
        return !(rootClassLoader instanceof ProjectClassLoader) || ((ProjectClassLoader)rootClassLoader).isClassInUse(className);
    }

    private boolean isFileInKBase(InternalKieModule kieModule, KieBaseModel kieBase, String fileName) {
        if (KieBuilderImpl.filterFileInKBase(kieModule, kieBase, fileName)) {
            return true;
        }
        for (String include : this.kProject.getTransitiveIncludes(kieBase)) {
            InternalKieModule includeModule = this.kProject.getKieModuleForKBase(include);
            if (includeModule == null || !KieBuilderImpl.filterFileInKBase(includeModule, this.kProject.getKieBaseModel(include), fileName)) continue;
            return true;
        }
        return false;
    }

    private void updateAllResources(InternalKieModule currentKM, InternalKieModule newKM, KieBaseModel kieBaseModel, KnowledgeBuilderImpl kbuilder, CompositeKnowledgeBuilder ckbuilder) {
        for (String resourceName : currentKM.getFileNames()) {
            if (resourceName.endsWith(".properties") || !this.isFileInKBase(currentKM, kieBaseModel, resourceName)) continue;
            Resource resource = currentKM.getResource(resourceName);
            kbuilder.removeObjectsGeneratedFromResource(resource);
        }
        for (String resourceName : newKM.getFileNames()) {
            if (resourceName.endsWith(".properties") || !this.isFileInKBase(newKM, kieBaseModel, resourceName)) continue;
            newKM.addResourceToCompiler(ckbuilder, kieBaseModel, resourceName);
        }
    }

    private int updateResourcesIncrementally(InternalKieModule currentKM, InternalKieModule newKM, KieJarChangeSet cs, List<String> modifiedClasses, KieBase kBase, KieBaseModel kieBaseModel, KnowledgeBuilderImpl kbuilder, CompositeKnowledgeBuilder ckbuilder) {
        int fileCount = modifiedClasses.size();
        for (ResourceChangeSet rcs : cs.getChanges().values()) {
            String resourceName;
            if (rcs.getChangeType() != ChangeType.REMOVED && !(resourceName = rcs.getResourceName()).endsWith(".properties") && this.isFileInKBase(newKM, kieBaseModel, resourceName)) {
                List changes = rcs.getChanges();
                if (!changes.isEmpty()) {
                    fileCount += AbstractKieModule.updateResource(ckbuilder, newKM, resourceName, rcs) ? 1 : 0;
                } else {
                    if (rcs.getChangeType() == ChangeType.UPDATED) {
                        Resource resource = currentKM.getResource(resourceName);
                        kbuilder.removeObjectsGeneratedFromResource(resource);
                    }
                    fileCount += newKM.addResourceToCompiler(ckbuilder, kieBaseModel, resourceName, rcs) ? 1 : 0;
                }
            }
            for (ResourceChangeSet.RuleLoadOrder loadOrder : rcs.getLoadOrder()) {
                RuleImpl rule;
                KnowledgePackageImpl pkg = (KnowledgePackageImpl)kBase.getKiePackage(loadOrder.getPkgName());
                if (pkg == null || (rule = pkg.getRule(loadOrder.getRuleName())) == null) continue;
                rule.setLoadOrder(loadOrder.getLoadOrder());
            }
        }
        return fileCount;
    }

    private void rebuildAll(ReleaseId newReleaseId, ResultsImpl results, InternalKieModule newKM, boolean modifyingUsedClass, KieBaseModel kieBaseModel, KnowledgeBuilderImpl kbuilder, CompositeKnowledgeBuilder ckbuilder) {
        ckbuilder.build();
        PackageBuilderErrors errors = kbuilder.getErrors();
        if (!errors.isEmpty()) {
            for (DroolsError error : errors.getErrors()) {
                results.addMessage(error).setKieBaseName(kieBaseModel.getName());
            }
            log.error("Unable to update KieBase: " + kieBaseModel.getName() + " to release " + newReleaseId + "\n" + errors.toString());
        }
        if (modifyingUsedClass) {
            kbuilder.rewireAllClassObjectTypes();
        }
    }

    private void reinitModifiedClasses(InternalKieModule newKM, List<String> modifiedClasses, ClassLoader classLoader) {
        if (!modifiedClasses.isEmpty() && classLoader instanceof ProjectClassLoader) {
            ProjectClassLoader projectClassLoader = (ProjectClassLoader)classLoader;
            projectClassLoader.reinitTypes();
            for (String resourceName : modifiedClasses) {
                String className = ClassUtils.convertResourceToClassName((String)resourceName);
                byte[] bytes = newKM.getBytes(resourceName);
                Class clazz = projectClassLoader.defineClass(className, resourceName, bytes);
            }
        }
    }

    private List<String> getModifiedClasses(KieJarChangeSet cs) {
        ArrayList<String> modifiedClasses = new ArrayList<String>();
        for (ResourceChangeSet rcs : cs.getChanges().values()) {
            String resourceName;
            if (rcs.getChangeType() == ChangeType.REMOVED || !(resourceName = rcs.getResourceName()).endsWith(".class")) continue;
            modifiedClasses.add(resourceName);
        }
        return modifiedClasses;
    }

    public Collection<String> getKieBaseNames() {
        return this.kProject.getKieBaseNames();
    }

    public Collection<String> getKieSessionNamesInKieBase(String kBaseName) {
        KieBaseModel kieBaseModel = this.kProject.getKieBaseModel(kBaseName);
        return kieBaseModel != null ? kieBaseModel.getKieSessionModels().keySet() : Collections.emptySet();
    }

    public KieBase getKieBase() {
        KieBaseModel defaultKieBaseModel = this.kProject.getDefaultKieBaseModel();
        if (defaultKieBaseModel == null) {
            throw new RuntimeException("Cannot find a default KieBase");
        }
        return this.getKieBase(defaultKieBaseModel.getName());
    }

    public Results verify() {
        return this.kProject.verify();
    }

    public Results verify(String ... kModelNames) {
        return this.kProject.verify(kModelNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KieBase getKieBase(String kBaseName) {
        KieBase kBase = this.kBases.get(kBaseName);
        if (kBase == null) {
            KieBaseModelImpl kBaseModel;
            KieBaseModelImpl kieBaseModelImpl = kBaseModel = this.getKieBaseModelImpl(kBaseName);
            synchronized (kieBaseModelImpl) {
                kBase = this.kBases.get(kBaseName);
                if (kBase == null) {
                    ResultsImpl msgs = new ResultsImpl();
                    kBase = this.createKieBase(kBaseModel, this.kProject, msgs, null);
                    if (kBase == null) {
                        throw new RuntimeException("Error while creating KieBase" + msgs.filterMessages(Message.Level.ERROR));
                    }
                    this.kBases.put(kBaseName, kBase);
                }
            }
        }
        return kBase;
    }

    public KieBase newKieBase(KieBaseConfiguration conf) {
        KieBaseModel defaultKieBaseModel = this.kProject.getDefaultKieBaseModel();
        if (defaultKieBaseModel == null) {
            throw new RuntimeException("Cannot find a default KieBase");
        }
        return this.newKieBase(defaultKieBaseModel.getName(), conf);
    }

    public KieBase newKieBase(String kBaseName, KieBaseConfiguration conf) {
        ResultsImpl msgs = new ResultsImpl();
        KieBase kBase = this.createKieBase(this.getKieBaseModelImpl(kBaseName), this.kProject, msgs, conf);
        if (kBase == null) {
            throw new RuntimeException("Error while creating KieBase" + msgs.filterMessages(Message.Level.ERROR));
        }
        return kBase;
    }

    private KieBase createKieBase(KieBaseModelImpl kBaseModel, KieProject kieProject, ResultsImpl messages, KieBaseConfiguration conf) {
        Object kbuilder;
        ClassLoader cl = kieProject.getClassLoader();
        InternalKieModule kModule = kieProject.getKieModuleForKBase(kBaseModel.getName());
        Collection<KnowledgePackage> pkgs = kModule.getKnowledgePackagesForKieBase(kBaseModel.getName());
        if (pkgs == null && (kbuilder = AbstractKieModule.buildKnowledgePackages(kBaseModel, kieProject, messages)).hasErrors()) {
            return null;
        }
        pkgs = kModule.getKnowledgePackagesForKieBase(kBaseModel.getName());
        if (kBaseModel.getEventProcessingMode() == EventProcessingOption.CLOUD && (conf == null || conf.getOption(EventProcessingOption.class) == EventProcessingOption.CLOUD)) {
            for (KnowledgePackage kpkg : pkgs) {
                if (!((KnowledgePackageImpl)kpkg).needsStreamMode()) continue;
                throw new RuntimeException("The requested KieBase \"" + kBaseModel.getName() + "\" has been set to run in CLOUD mode but requires features only available in STREAM mode");
            }
        }
        if (conf == null) {
            conf = this.getKnowledgeBaseConfiguration(kBaseModel, cl);
        } else if (conf instanceof RuleBaseConfiguration) {
            ((RuleBaseConfiguration)conf).setClassLoader(cl);
        }
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((String)kBaseModel.getName(), (KieBaseConfiguration)conf);
        kBase.setResolvedReleaseId(this.containerReleaseId);
        kBase.setContainerId(this.containerId);
        kBase.initMBeans();
        kBase.addKnowledgePackages(pkgs);
        return kBase;
    }

    private KieBaseModelImpl getKieBaseModelImpl(String kBaseName) {
        KieBaseModelImpl kBaseModel = (KieBaseModelImpl)this.kProject.getKieBaseModel(kBaseName);
        if (kBaseModel == null) {
            throw new RuntimeException("The requested KieBase \"" + kBaseName + "\" does not exist");
        }
        return kBaseModel;
    }

    private KieBaseConfiguration getKnowledgeBaseConfiguration(KieBaseModelImpl kBaseModel, ClassLoader cl) {
        KieBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{cl});
        kbConf.setOption((KieBaseOption)kBaseModel.getEqualsBehavior());
        kbConf.setOption((KieBaseOption)kBaseModel.getEventProcessingMode());
        kbConf.setOption((KieBaseOption)kBaseModel.getDeclarativeAgenda());
        return kbConf;
    }

    public KieSession newKieSession() {
        return this.newKieSession((Environment)null, null);
    }

    @Override
    public KieSession getKieSession() {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(false);
        return this.getKieSession(defaultKieSessionModel.getName());
    }

    public KieSession newKieSession(KieSessionConfiguration conf) {
        return this.newKieSession((Environment)null, conf);
    }

    public KieSession newKieSession(Environment environment) {
        return this.newKieSession(environment, null);
    }

    public KieSession newKieSession(Environment environment, KieSessionConfiguration conf) {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(false);
        return this.newKieSession(defaultKieSessionModel.getName(), environment, conf);
    }

    private KieSessionModel findKieSessionModel(boolean stateless) {
        KieSessionModel defaultKieSessionModel;
        KieSessionModel kieSessionModel = defaultKieSessionModel = stateless ? this.kProject.getDefaultStatelessKieSession() : this.kProject.getDefaultKieSession();
        if (defaultKieSessionModel == null) {
            throw new RuntimeException(stateless ? "Cannot find a default StatelessKieSession" : "Cannot find a default KieSession");
        }
        return defaultKieSessionModel;
    }

    public StatelessKieSession newStatelessKieSession() {
        return this.newStatelessKieSession((KieSessionConfiguration)null);
    }

    public StatelessKieSession newStatelessKieSession(KieSessionConfiguration conf) {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(true);
        return this.newStatelessKieSession(defaultKieSessionModel.getName(), conf);
    }

    @Override
    public StatelessKieSession getStatelessKieSession() {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(true);
        return this.getStatelessKieSession(defaultKieSessionModel.getName());
    }

    public KieSession newKieSession(String kSessionName) {
        return this.newKieSession(kSessionName, null, null);
    }

    @Override
    public KieSession getKieSession(String kSessionName) {
        KieSession kieSession = this.kSessions.get(kSessionName);
        if (kieSession instanceof StatefulKnowledgeSessionImpl && !((StatefulKnowledgeSessionImpl)kieSession).isAlive()) {
            this.kSessions.remove(kSessionName);
            kieSession = null;
        }
        return kieSession != null ? kieSession : this.newKieSession(kSessionName);
    }

    public KieSession newKieSession(String kSessionName, Environment environment) {
        return this.newKieSession(kSessionName, environment, null);
    }

    public KieSession newKieSession(String kSessionName, KieSessionConfiguration conf) {
        return this.newKieSession(kSessionName, null, conf);
    }

    public KieSession newKieSession(String kSessionName, Environment environment, KieSessionConfiguration conf) {
        KieSessionModelImpl kSessionModel;
        KieSessionModelImpl kieSessionModelImpl = kSessionModel = kSessionName != null ? (KieSessionModelImpl)this.getKieSessionModel(kSessionName) : (KieSessionModelImpl)this.findKieSessionModel(false);
        if (kSessionModel == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        if (kSessionModel.getType() == KieSessionModel.KieSessionType.STATELESS) {
            throw new RuntimeException("Trying to create a stateful KieSession from a stateless KieSessionModel: " + kSessionModel.getName());
        }
        KieBase kBase = this.getKieBase(kSessionModel.getKieBaseModel().getName());
        if (kBase == null) {
            log.error("Unknown KieBase name: " + kSessionModel.getKieBaseModel().getName());
            return null;
        }
        KieSession kSession = kBase.newKieSession(conf != null ? conf : this.getKieSessionConfiguration(kSessionModel), environment);
        if (Drools.isJndiAvailable()) {
            CDIHelper.wireListnersAndWIHs((KieSessionModel)kSessionModel, kSession);
        }
        this.registerLoggers(kSessionModel, (KieRuntimeEventManager)kSession);
        ((StatefulKnowledgeSessionImpl)kSession).initMBeans(this.containerId, ((InternalKnowledgeBase)kBase).getId(), kSessionModel.getName());
        this.kSessions.put(kSessionModel.getName(), kSession);
        return kSession;
    }

    private void registerLoggers(KieSessionModelImpl kSessionModel, KieRuntimeEventManager kSession) {
        FileLoggerModel fileLogger;
        KieLoggers kieLoggers = KieServices.Factory.get().getLoggers();
        if (kSessionModel.getConsoleLogger() != null) {
            kieLoggers.newConsoleLogger(kSession);
        }
        if ((fileLogger = kSessionModel.getFileLogger()) != null) {
            if (fileLogger.isThreaded()) {
                kieLoggers.newThreadedFileLogger(kSession, fileLogger.getFile(), fileLogger.getInterval());
            } else {
                kieLoggers.newFileLogger(kSession, fileLogger.getFile());
            }
        }
    }

    public StatelessKieSession newStatelessKieSession(String kSessionName) {
        return this.newStatelessKieSession(kSessionName, null);
    }

    public StatelessKieSession newStatelessKieSession(String kSessionName, KieSessionConfiguration conf) {
        KieSessionModelImpl kSessionModel;
        KieSessionModelImpl kieSessionModelImpl = kSessionModel = kSessionName != null ? (KieSessionModelImpl)this.getKieSessionModel(kSessionName) : (KieSessionModelImpl)this.findKieSessionModel(true);
        if (kSessionModel == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        if (kSessionModel.getType() == KieSessionModel.KieSessionType.STATEFUL) {
            throw new RuntimeException("Trying to create a stateless KieSession from a stateful KieSessionModel: " + kSessionModel.getName());
        }
        KieBase kBase = this.getKieBase(kSessionModel.getKieBaseModel().getName());
        if (kBase == null) {
            log.error("Unknown KieBase name: " + kSessionModel.getKieBaseModel().getName());
            return null;
        }
        StatelessKieSession statelessKieSession = kBase.newStatelessKieSession(conf != null ? conf : this.getKieSessionConfiguration(kSessionModel));
        if (Drools.isJndiAvailable()) {
            CDIHelper.wireListnersAndWIHs((KieSessionModel)kSessionModel, statelessKieSession);
        }
        this.registerLoggers(kSessionModel, (KieRuntimeEventManager)statelessKieSession);
        ((StatelessKnowledgeSessionImpl)statelessKieSession).initMBeans(this.containerId, ((InternalKnowledgeBase)kBase).getId(), kSessionModel.getName());
        this.statelessKSessions.put(kSessionModel.getName(), statelessKieSession);
        return statelessKieSession;
    }

    @Override
    public StatelessKieSession getStatelessKieSession(String kSessionName) {
        StatelessKieSession kieSession = this.statelessKSessions.get(kSessionName);
        return kieSession != null ? kieSession : this.newStatelessKieSession(kSessionName);
    }

    public KieSessionConfiguration getKieSessionConfiguration() {
        return this.getKieSessionConfiguration(this.kProject.getDefaultKieSession());
    }

    public KieSessionConfiguration getKieSessionConfiguration(String kSessionName) {
        KieSessionModelImpl kSessionModel = (KieSessionModelImpl)this.kProject.getKieSessionModel(kSessionName);
        if (kSessionModel == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        return this.getKieSessionConfiguration(kSessionModel);
    }

    private KieSessionConfiguration getKieSessionConfiguration(KieSessionModel kSessionModel) {
        KieSessionConfiguration ksConf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksConf.setOption((KieSessionOption)kSessionModel.getClockType());
        ksConf.setOption((KieSessionOption)kSessionModel.getBeliefSystem());
        return ksConf;
    }

    public void dispose() {
        HashSet<DroolsManagementAgent.CBSKey> cbskeys = new HashSet<DroolsManagementAgent.CBSKey>();
        if (this.isMBeanOptionEnabled()) {
            for (Map.Entry<String, KieSession> entry : this.kSessions.entrySet()) {
                cbskeys.add(new DroolsManagementAgent.CBSKey(this.containerId, ((InternalKnowledgeBase)entry.getValue().getKieBase()).getId(), entry.getKey()));
            }
            for (Map.Entry<String, KieSession> entry : this.statelessKSessions.entrySet()) {
                cbskeys.add(new DroolsManagementAgent.CBSKey(this.containerId, ((InternalKnowledgeBase)((StatelessKieSession)entry.getValue()).getKieBase()).getId(), entry.getKey()));
            }
        }
        for (KieSession kieSession : this.kSessions.values()) {
            kieSession.dispose();
        }
        this.kSessions.clear();
        this.statelessKSessions.clear();
        if (this.isMBeanOptionEnabled()) {
            for (DroolsManagementAgent.CBSKey cBSKey : cbskeys) {
                DroolsManagementAgent.getInstance().unregisterKnowledgeSessionBean(cBSKey);
            }
            for (KieBase kieBase : this.kBases.values()) {
                DroolsManagementAgent.getInstance().unregisterKnowledgeBase((InternalKnowledgeBase)kieBase);
            }
            DroolsManagementAgent.getInstance().unregisterMBeansFromOwner((Object)this);
        }
        ((InternalKieServices)KieServices.Factory.get()).clearRefToContainerId(this.containerId, this);
    }

    private boolean isMBeanOptionEnabled() {
        return MBeansOption.isEnabled((String)System.getProperty("kie.mbeans", MBeansOption.DISABLED.toString()));
    }

    public KieProject getKieProject() {
        return this.kProject;
    }

    public KieModule getKieModuleForKBase(String kBaseName) {
        return this.kProject.getKieModuleForKBase(kBaseName);
    }

    public KieBaseModel getKieBaseModel(String kBaseName) {
        return this.kProject.getKieBaseModel(kBaseName);
    }

    public KieSessionModel getKieSessionModel(String kSessionName) {
        return this.kProject.getKieSessionModel(kSessionName);
    }

    public ClassLoader getClassLoader() {
        return this.kProject.getClassLoader();
    }
}

