% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrateHalfnormPoints.R
\name{integrateHalfnormPoints}
\alias{integrateHalfnormPoints}
\title{Integrate Half-normal Point transects}
\usage{
integrateHalfnormPoints(
  object,
  newdata = NULL,
  w.lo = NULL,
  w.hi = NULL,
  Units = NULL
)
}
\arguments{
\item{object}{Either an Rdistance fitted distance function
(an object that inherits from class "dfunc"; usually produced 
by a call to \code{\link{dfuncEstim}}), or a matrix of canonical 
distance function parameters (e.g., \code{matrix(fit$par,1)}). 
If a matrix, each row corresponds to a 
distance function and each column is a parameter. If 
\code{object} is a matrix, it should not have measurement units. 
Only quantities derived from function parameters (e.g., ESW) have units. 
Rdistance function parameters themselves never have units.}

\item{newdata}{A data frame containing new values for 
the distance function covariates. If NULL and 
\code{object} is a fitted distance function, the  
observed covariates stored in
\code{object} are used (behavior similar to \code{\link{predict.lm}}).
Argument \code{newdata} is ignored if \code{object} is a matrix.}

\item{w.lo}{Minimum sighting distance or left-truncation value
if \code{object} is a matrix.
Ignored if \code{object} 
is a fitted distance function. 
Must have physical measurement units.}

\item{w.hi}{Maximum sighting distance or right-truncation value
if \code{object} is a matrix.
Ignored if \code{object} 
is a fitted distance function.
Must have physical measurement units.}

\item{Units}{Physical units of sighting distances if 
\code{object} is a matrix. Sighting distance units can differ from units 
of \code{w.lo} or \code{w.hi}.   Ignored if \code{object}
is a fitted distance function.}
}
\value{
A vector of areas under distance functions. 
If \code{object} is a distance function and 
\code{newdata} is specified, the returned vector's length is 
\code{nrow(newdata)}.  If \code{object} is a distance function and 
\code{newdata} is NULL, 
returned vector's length is \code{length(distances(object))}. If 
\code{object} is a matrix, return's length is 
\code{nrow(object)}.
}
\description{
Compute integral of the half-normal distance function for 
point surveys.
}
\details{
Returned integrals are 
\deqn{\int_0^{w} xe^{-x^2/2\sigma_i^2} dx = 0.5\sigma_i^2(1 - e^{-w^2/2\sigma_i^2}),}{
Integral(xe^{-x^2/(2s^2)}) = 0.5*s^2*(1 - exp(-w^2/(2*s^2))),} 
where \eqn{w = w.hi - w.lo} and \eqn{\sigma_i}{s} is the estimated half-normal 
distance function parameter for the i-th observed distance.
}
\section{Note}{

Users will not normally call this function. It is called 
internally by \code{\link{nLL}} and \code{\link{effectiveDistance}}. 
Users normally 
call \code{\link{effectiveDistance}} to compute integrals.
}

\examples{

# Fake distance function object w/ minimum inputs for integration
d <- rep(1,4) \%m\%. # Only units needed, not values
obs <- factor(rep(c("obs1", "obs2"), 2))
beta <- c(3.5, -0.5)
w.hi <- 125
w.lo <- 20
ml <- list(
    mf = model.frame(d ~ obs)
  , par = beta 
  , likelihood = "halfnorm"
  , w.lo = w.lo \%#\% "m"
  , w.hi = w.hi \%#\% "m"
)
class(ml) <- "dfunc"
integrateHalfnormPoints(ml)

# Check: Integral of x exp(-x^2/(2*s^2)) from 0 to w = w.hi-w.lo
sigma <- exp(c(beta[1], beta[1] + beta[2]))
w <- w.hi - w.lo
intgral <- sigma^2 * (1 - exp(-w^2 / (2*sigma^2)))
intgral

# Effective detection radius
sqrt(2 * intgral)

}
\seealso{
\code{\link{integrateNumeric}}; \code{\link{integrateNegexpPoints}}; 
\code{\link{integrateOneStepPoints}}
}
