% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mle1.R
\name{est.mle1}
\alias{est.mle1}
\title{Maximum Likelihood Esimation with Poisson Process}
\usage{
est.mle1(X, k1 = 10, k2 = 20)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{k1}{minimum neighborhood size, larger than 1.}

\item{k2}{maximum neighborhood size, smaller than \eqn{n}.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated intrinsic dimension.}
}
}
\description{
Assuming the density in a hypersphere is constant, authors proposed to build
a likelihood structure based on modeling local spread of information via Poisson Process.
\code{est.mle1} requires two parameters that model the reasonable range of neighborhood size
to reflect inhomogeneity of distribution across data points.
}
\examples{
\donttest{
## create example data sets with intrinsic dimension 2
X1 = aux.gensamples(dname="swiss")
X2 = aux.gensamples(dname="ribbon")
X3 = aux.gensamples(dname="saddle")

## acquire an estimate for intrinsic dimension
out1 = est.mle1(X1)
out2 = est.mle1(X2)
out3 = est.mle1(X3)

## print the estimates
line1 = paste0("* est.mle1 : 'swiss'  estiamte is ",round(out1$estdim,2))
line2 = paste0("* est.mle1 : 'ribbon' estiamte is ",round(out2$estdim,2))
line3 = paste0("* est.mle1 : 'saddle' estiamte is ",round(out3$estdim,2))
cat(paste0(line1,"\n",line2,"\n",line3))
}

}
\references{
\insertRef{levina_maximum_2005}{Rdimtools}
}
\author{
Kisung You
}
