% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admeadian.R
\name{admedian}
\alias{admedian}
\title{Adaptive meadian background subtraction algorithm}
\usage{
admedian(b, nf, thresh)
}
\arguments{
\item{b}{3-D matrix containing grayscaled video frames.}

\item{nf}{Number of previous frames to be taken into consideration.}

\item{thresh}{threshold required to obtain foreground images. its value can be around 10 to 30 depending
upon the accuracy of the result.}
}
\value{
A 3-D matrix of frames containing foreground obtained after background subtraction
 is applied(binary images).
}
\description{
This function performs background subtraction on input grayscale frames using adaptive median
background subtraction algorithm.The algorithm depends upon the number of previous frames taken
into consideration.
}
\examples{
 \donttest{
videoURL <- system.file("extdata","daria_skip.avi",package = "Rbgs")
frames <- readvideoframe(videoURL,1,15)
bground<-admedian(frames,3,25) }

}
