% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_leslie_matrix.R
\name{is_leslie_matrix}
\alias{is_leslie_matrix}
\title{Determine if a matrix is a Leslie matrix population model}
\usage{
is_leslie_matrix(A, includes_mat_F = TRUE)
}
\arguments{
\item{A}{Matrix to be tested}

\item{includes_mat_F}{A logical argument (default `TRUE`) indicating whether
A is expected to include fecundity. The idea here is that A may not include
fertility, but could still be a valid Leslie matrix if fertility was truly
measured to be 0, or if fertility was not measured at all. Thus, this
argument relaxes the test for the first row of A summing to a positive
value.}
}
\value{
A logical value indicating whether the matrix is a Leslie matrix or
not
}
\description{
Checks if a given matrix is a Leslie matrix.
A matrix is determined to be a Leslie matrix if it satisfies the following
conditions:
* All elements of A are non-negative.
* The subdiagonal elements of A, excluding the last column, are all between 0
 and 1.
* The sum of the elements in the first row (representing reproduction) of A
is positive.
* The upper triangle of A, excluding the first row, contains only 0s.
* The diagonal of A, excluding the top-left and bottom-right corners contain
only 0s.
* The lower triangle of A, excluding the subdiagonal, contains only 0s.
}
\examples{
A <- matrix(c(
  0.1, 1.2, 1.1,
  0.1, 0.0, 0.0,
  0.0, 0.2, 0.3
), nrow = 3, byrow = TRUE)
is_leslie_matrix(A) # true
A <- matrix(c(
  0.1, 1.2, 1.1,
  0.1, 0.2, 0.1,
  0.2, 0.3, 0.3
), nrow = 3, byrow = TRUE)
is_leslie_matrix(A) # false

data(leslie_mpm1)
A <- leslie_mpm1$matU + leslie_mpm1$matF
is_leslie_matrix(A) # false

}
\seealso{
Other transformation: 
\code{\link{leslie_collapse}()},
\code{\link{mpm_collapse}()},
\code{\link{mpm_rearrange}()},
\code{\link{mpm_split}()},
\code{\link{mpm_standardize}()},
\code{\link{name_stages}()},
\code{\link{repro_stages}()},
\code{\link{standard_stages}()}
}
\author{
Owen Jones <jones@biology.sdu.dk>
}
\concept{transformation}
