% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Radviz-package.R
\docType{package}
\name{Radviz-package}
\alias{Radviz}
\alias{Radviz-package}
\title{Radviz: Project Multidimensional Data in 2D Space}
\description{
An implementation of the radviz projection in R. It enables the visualization of multidimensional data while maintaining the relation to the original dimensions. This package provides functions to create and plot radviz projections, and a number of summary plots that enable comparison and analysis. For reference see Hoffman *et al.* (1999) (\doi{10.1145/331770.331775}) for original implementation, see Di Caro *et al* (2012) (\doi{10.1007/978-3-642-13672-6_13}), for the original method for dimensional anchor arrangements, see Demsar *et al.* (2007) (\doi{10.1016/j.jbi.2007.03.010}) for the original Freeviz implementation.

Radviz uses Dimensional Anchors and the spring paradigm to project a multidimensional space in 2D.
This allows for the quick visualization of large and complex datasets.
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
plot(rv,anchors.only=FALSE)

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/yannabraham/Radviz}
  \item Report bugs at \url{https://github.com/yannabraham/Radviz/issues}
}

}
\author{
\strong{Maintainer}: Yann Abraham \email{yann.abraham@gmail.com}

Authors:
\itemize{
  \item Nicolas Sauwen \email{nicolas.sauwen@openanalytics.eu}
}

}
\keyword{internal}
