% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{compumap}
\alias{compumap}
\title{Computation of a two dimensional umap representation}
\usage{
compumap(object, dimRed = FALSE, umap.pars = umap.defaults)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{dimRed}{logical. If \code{TRUE} then the umap is computed from the feature matrix in slot \code{dimRed$x} (if not equal to \code{NULL}).
Default is \code{FALSE} and the umap is computed from the distance matrix stored in slot \code{distances}. If slot \code{distances} equals \code{NULL}
\code{dimRed} is automatially set to \code{TRUE}.}

\item{umap.pars}{umap parameters. See \pkg{umap} package, \code{umap.defaults}. Default is \code{umap.defaults}. \code{umap.pars$input} is automatically
set to \code{"dist"} if \code{dimRed} is \code{FALSE}.}
}
\value{
\code{SCseq} object with umap coordinates stored in slot \code{umap}.
}
\description{
This functions performs the computation of a two-dimensional umap representation based on the distance matrix in
slot \code{distances} using the \pkg{umap} package.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
sc <- clustexp(sc)
sc <- findoutliers(sc)
sc <- compumap(sc)
}
