/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.knowledgeflow.GOEStepEditorDialog;
import weka.knowledgeflow.steps.ClassAssigner;
import weka.knowledgeflow.steps.Step;

public class ClassAssignerStepEditorDialog
extends GOEStepEditorDialog {
    private static final long serialVersionUID = 3105898651212196539L;
    protected JComboBox<String> m_classCombo = new JComboBox();

    @Override
    public void setStepToEdit(Step step) {
        this.copyOriginal(step);
        Instances incomingStructure = null;
        try {
            incomingStructure = step.getStepManager().getIncomingStructureForConnectionType("dataSet");
            if (incomingStructure == null) {
                incomingStructure = step.getStepManager().getIncomingStructureForConnectionType("trainingSet");
            }
            if (incomingStructure == null) {
                incomingStructure = step.getStepManager().getIncomingStructureForConnectionType("testSet");
            }
            if (incomingStructure == null) {
                incomingStructure = step.getStepManager().getIncomingStructureForConnectionType("instance");
            }
        }
        catch (WekaException ex) {
            this.showErrorDialog(ex);
        }
        if (incomingStructure != null) {
            this.m_classCombo.setEditable(true);
            for (int i = 0; i < incomingStructure.numAttributes(); ++i) {
                Attribute a = incomingStructure.attribute(i);
                String attN = "(" + Attribute.typeToStringShort(a) + ") " + a.name();
                this.m_classCombo.addItem(attN);
            }
            this.setComboToClass(incomingStructure);
            JPanel p = new JPanel(new BorderLayout());
            p.setBorder(BorderFactory.createTitledBorder("Choose class attribute"));
            p.add(this.m_classCombo, "North");
            this.createAboutPanel(step);
            this.add((Component)p, "Center");
        } else {
            this.m_classCombo = null;
            super.setStepToEdit(step);
        }
    }

    protected void setComboToClass(Instances incomingStructure) {
        String stepC = ((ClassAssigner)this.getStepToEdit()).getClassColumn();
        if (stepC != null && stepC.length() > 0) {
            if (stepC.equalsIgnoreCase("/first")) {
                this.m_classCombo.setSelectedIndex(0);
            } else if (stepC.equalsIgnoreCase("/last")) {
                this.m_classCombo.setSelectedIndex(this.m_classCombo.getItemCount() - 1);
            } else {
                Attribute a = incomingStructure.attribute(stepC);
                if (a != null) {
                    String attN = "(" + Attribute.typeToStringShort(a) + ") " + a.name();
                    this.m_classCombo.setSelectedItem(attN);
                } else {
                    try {
                        int num = Integer.parseInt(stepC);
                        if (--num >= 0 && num < incomingStructure.numAttributes()) {
                            this.m_classCombo.setSelectedIndex(num);
                        }
                    }
                    catch (NumberFormatException e) {
                        this.m_classCombo.setSelectedItem(stepC);
                    }
                }
            }
        }
    }

    @Override
    public void okPressed() {
        if (this.m_classCombo != null) {
            String selected = this.m_classCombo.getSelectedItem().toString();
            selected = selected.substring(selected.indexOf(41) + 1, selected.length()).trim();
            ((ClassAssigner)this.getStepToEdit()).setClassColumn(selected);
        }
    }
}

