/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.SimpleStreamFilter;
import weka.filters.unsupervised.attribute.Remove;

public class RemoveByName
extends SimpleStreamFilter {
    private static final long serialVersionUID = -3335106965521265631L;
    public static final String DEFAULT_EXPRESSION = "^.*id$";
    protected String m_Expression = "^.*id$";
    protected boolean m_InvertSelection;
    protected Remove m_Remove;

    public String globalInfo() {
        return "Removes attributes based on a regular expression matched against their names.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tThe regular expression to match the attribute names against.\n\t(default: ^.*id$)", "E", 1, "-E <regular expression>"));
        result.addElement(new Option("\tFlag for inverting the matching sense. If set, attributes are kept\n\tinstead of deleted.\n\t(default: off)", "V", 0, "-V"));
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-E");
        result.add("" + this.getExpression());
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption("E", options);
        if (tmpStr.length() != 0) {
            this.setExpression(tmpStr);
        } else {
            this.setExpression(DEFAULT_EXPRESSION);
        }
        this.setInvertSelection(Utils.getFlag("V", options));
    }

    public void setExpression(String value) {
        this.m_Expression = value;
    }

    public String getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The regular expression to match the attribute names against.";
    }

    public void setInvertSelection(boolean value) {
        this.m_InvertSelection = value;
    }

    public boolean getInvertSelection() {
        return this.m_InvertSelection;
    }

    public String invertSelectionTipText() {
        return "Determines whether action is to select or delete. If set to true, only the specified attributes will be kept; If set to false, specified attributes will be deleted.";
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        Vector<Integer> indices = new Vector<Integer>();
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            if (i == inputFormat.classIndex() || !inputFormat.attribute(i).name().matches(this.m_Expression)) continue;
            indices.add(i);
        }
        int[] attributes = new int[indices.size()];
        for (i = 0; i < indices.size(); ++i) {
            attributes[i] = (Integer)indices.get(i);
        }
        this.m_Remove = new Remove();
        this.m_Remove.setAttributeIndicesArray(attributes);
        this.m_Remove.setInvertSelection(this.getInvertSelection());
        this.m_Remove.setInputFormat(inputFormat);
        return this.m_Remove.getOutputFormat();
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Remove().getCapabilities();
        result.setOwner(this);
        return result;
    }

    protected Instance process(Instance instance) throws Exception {
        this.m_Remove.input(instance);
        return this.m_Remove.output();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        RemoveByName.runFilter(new RemoveByName(), args);
    }
}

