/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.net.EditableBayesNet;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.estimators.Estimator;

public class BayesNetGenerator
extends EditableBayesNet {
    int m_nSeed = 1;
    Random random;
    static final long serialVersionUID = -7462571170596157720L;
    boolean m_bGenerateNet = false;
    int m_nNrOfNodes = 10;
    int m_nNrOfArcs = 10;
    int m_nNrOfInstances = 10;
    int m_nCardinality = 2;
    String m_sBIFFile = "";

    public void generateRandomNetwork() throws Exception {
        if (this.m_otherBayesNet == null) {
            this.Init(this.m_nNrOfNodes, this.m_nCardinality);
            this.generateRandomNetworkStructure(this.m_nNrOfNodes, this.m_nNrOfArcs);
            this.generateRandomDistributions(this.m_nNrOfNodes, this.m_nCardinality);
        } else {
            this.m_nNrOfNodes = this.m_otherBayesNet.getNrOfNodes();
            this.m_ParentSets = this.m_otherBayesNet.getParentSets();
            this.m_Distributions = this.m_otherBayesNet.getDistributions();
            this.random = new Random(this.m_nSeed);
            FastVector<Attribute> attInfo = new FastVector<Attribute>(this.m_nNrOfNodes);
            for (int iNode = 0; iNode < this.m_nNrOfNodes; ++iNode) {
                int nValues = this.m_otherBayesNet.getCardinality(iNode);
                FastVector<String> nomStrings = new FastVector<String>(nValues + 1);
                for (int iValue = 0; iValue < nValues; ++iValue) {
                    nomStrings.addElement(this.m_otherBayesNet.getNodeValue(iNode, iValue));
                }
                Attribute att = new Attribute(this.m_otherBayesNet.getNodeName(iNode), nomStrings);
                attInfo.addElement(att);
            }
            this.m_Instances = new Instances(this.m_otherBayesNet.getName(), attInfo, 100);
            this.m_Instances.setClassIndex(this.m_nNrOfNodes - 1);
        }
    }

    public void Init(int nNodes, int nValues) throws Exception {
        int i;
        int iNode;
        this.random = new Random(this.m_nSeed);
        FastVector<Attribute> attInfo = new FastVector<Attribute>(nNodes);
        FastVector<String> nomStrings = new FastVector<String>(nValues + 1);
        for (int iValue = 0; iValue < nValues; ++iValue) {
            nomStrings.addElement("Value" + (iValue + 1));
        }
        for (iNode = 0; iNode < nNodes; ++iNode) {
            Attribute att = new Attribute("Node" + (iNode + 1), nomStrings);
            attInfo.addElement(att);
        }
        this.m_Instances = new Instances("RandomNet", attInfo, 100);
        this.m_Instances.setClassIndex(nNodes - 1);
        this.setUseADTree(false);
        this.initStructure();
        this.m_Distributions = new Estimator[nNodes][1];
        for (iNode = 0; iNode < nNodes; ++iNode) {
            this.m_Distributions[iNode][0] = new DiscreteEstimatorBayes(nValues, this.getEstimator().getAlpha());
        }
        this.m_nEvidence = new FastVector(nNodes);
        for (i = 0; i < nNodes; ++i) {
            this.m_nEvidence.addElement(-1);
        }
        this.m_fMarginP = new FastVector(nNodes);
        for (i = 0; i < nNodes; ++i) {
            double[] P = new double[this.getCardinality(i)];
            this.m_fMarginP.addElement(P);
        }
        this.m_nPositionX = new FastVector(nNodes);
        this.m_nPositionY = new FastVector(nNodes);
        for (iNode = 0; iNode < nNodes; ++iNode) {
            this.m_nPositionX.addElement(iNode % 10 * 50);
            this.m_nPositionY.addElement(iNode / 10 * 50);
        }
    }

    public void generateRandomNetworkStructure(int nNodes, int nArcs) throws Exception {
        if (nArcs < nNodes - 1) {
            throw new Exception("Number of arcs should be at least (nNodes - 1) = " + (nNodes - 1) + " instead of " + nArcs);
        }
        if (nArcs > nNodes * (nNodes - 1) / 2) {
            throw new Exception("Number of arcs should be at most nNodes * (nNodes - 1) / 2 = " + nNodes * (nNodes - 1) / 2 + " instead of " + nArcs);
        }
        if (nArcs == 0) {
            return;
        }
        this.generateTree(nNodes);
        for (int iArc = nNodes - 1; iArc < nArcs; ++iArc) {
            boolean bDone = false;
            while (!bDone) {
                int nNode2;
                int nNode1 = this.random.nextInt(nNodes);
                if (nNode1 == (nNode2 = this.random.nextInt(nNodes))) {
                    nNode2 = (nNode1 + 1) % nNodes;
                }
                if (nNode2 < nNode1) {
                    int h = nNode1;
                    nNode1 = nNode2;
                    nNode2 = h;
                }
                if (this.m_ParentSets[nNode2].contains(nNode1)) continue;
                this.m_ParentSets[nNode2].addParent(nNode1, this.m_Instances);
                bDone = true;
            }
        }
    }

    void generateTree(int nNodes) {
        int nNode2;
        boolean[] bConnected = new boolean[nNodes];
        int nNode1 = this.random.nextInt(nNodes);
        if (nNode1 == (nNode2 = this.random.nextInt(nNodes))) {
            nNode2 = (nNode1 + 1) % nNodes;
        }
        if (nNode2 < nNode1) {
            int h = nNode1;
            nNode1 = nNode2;
            nNode2 = h;
        }
        this.m_ParentSets[nNode2].addParent(nNode1, this.m_Instances);
        bConnected[nNode1] = true;
        bConnected[nNode2] = true;
        for (int iArc = 2; iArc < nNodes; ++iArc) {
            int nNode;
            nNode1 = 0;
            for (nNode = this.random.nextInt(nNodes); nNode >= 0; --nNode) {
                nNode1 = (nNode1 + 1) % nNodes;
                while (!bConnected[nNode1]) {
                    nNode1 = (nNode1 + 1) % nNodes;
                }
            }
            nNode2 = 0;
            for (nNode = this.random.nextInt(nNodes); nNode >= 0; --nNode) {
                nNode2 = (nNode2 + 1) % nNodes;
                while (bConnected[nNode2]) {
                    nNode2 = (nNode2 + 1) % nNodes;
                }
            }
            if (nNode2 < nNode1) {
                int h = nNode1;
                nNode1 = nNode2;
                nNode2 = h;
            }
            this.m_ParentSets[nNode2].addParent(nNode1, this.m_Instances);
            bConnected[nNode1] = true;
            bConnected[nNode2] = true;
        }
    }

    void generateRandomDistributions(int nNodes, int nValues) {
        int iAttribute;
        int nMaxParentCardinality = 1;
        for (iAttribute = 0; iAttribute < nNodes; ++iAttribute) {
            if (this.m_ParentSets[iAttribute].getCardinalityOfParents() <= nMaxParentCardinality) continue;
            nMaxParentCardinality = this.m_ParentSets[iAttribute].getCardinalityOfParents();
        }
        this.m_Distributions = new Estimator[this.m_Instances.numAttributes()][nMaxParentCardinality];
        for (iAttribute = 0; iAttribute < nNodes; ++iAttribute) {
            int[] nPs = new int[nValues + 1];
            nPs[0] = 0;
            nPs[nValues] = 1000;
            for (int iParent = 0; iParent < this.m_ParentSets[iAttribute].getCardinalityOfParents(); ++iParent) {
                int iValue;
                for (iValue = 1; iValue < nValues; ++iValue) {
                    nPs[iValue] = this.random.nextInt(1000);
                }
                for (iValue = 1; iValue < nValues; ++iValue) {
                    for (int iValue2 = iValue + 1; iValue2 < nValues; ++iValue2) {
                        if (nPs[iValue2] >= nPs[iValue]) continue;
                        int h = nPs[iValue2];
                        nPs[iValue2] = nPs[iValue];
                        nPs[iValue] = h;
                    }
                }
                DiscreteEstimatorBayes d = new DiscreteEstimatorBayes(nValues, this.getEstimator().getAlpha());
                for (int iValue2 = 0; iValue2 < nValues; ++iValue2) {
                    d.addValue(iValue2, nPs[iValue2 + 1] - nPs[iValue2]);
                }
                this.m_Distributions[iAttribute][iParent] = d;
            }
        }
    }

    public void generateInstances() throws Exception {
        int[] order = this.getOrder();
        for (int iInstance = 0; iInstance < this.m_nNrOfInstances; ++iInstance) {
            int nNrOfAtts = this.m_Instances.numAttributes();
            DenseInstance instance = new DenseInstance(nNrOfAtts);
            instance.setDataset(this.m_Instances);
            for (int iAtt2 = 0; iAtt2 < nNrOfAtts; ++iAtt2) {
                int iAtt = order[iAtt2];
                double iCPT = 0.0;
                for (int iParent = 0; iParent < this.m_ParentSets[iAtt].getNrOfParents(); ++iParent) {
                    int nParent = this.m_ParentSets[iAtt].getParent(iParent);
                    iCPT = iCPT * (double)this.m_Instances.attribute(nParent).numValues() + instance.value(nParent);
                }
                double fRandom = (float)this.random.nextInt(1000) / 1000.0f;
                int iValue = 0;
                while (fRandom > this.m_Distributions[iAtt][(int)iCPT].getProbability(iValue)) {
                    fRandom -= this.m_Distributions[iAtt][(int)iCPT].getProbability(iValue);
                    ++iValue;
                }
                instance.setValue(iAtt, (double)iValue);
            }
            this.m_Instances.add(instance);
        }
    }

    int[] getOrder() throws Exception {
        int nNrOfAtts = this.m_Instances.numAttributes();
        int[] order = new int[nNrOfAtts];
        boolean[] bDone = new boolean[nNrOfAtts];
        for (int iAtt = 0; iAtt < nNrOfAtts; ++iAtt) {
            int iAtt2 = 0;
            boolean allParentsDone = false;
            while (!allParentsDone && iAtt2 < nNrOfAtts) {
                if (!bDone[iAtt2]) {
                    allParentsDone = true;
                    int iParent = 0;
                    while (allParentsDone && iParent < this.m_ParentSets[iAtt2].getNrOfParents()) {
                        allParentsDone = bDone[this.m_ParentSets[iAtt2].getParent(iParent++)];
                    }
                    if (allParentsDone && iParent == this.m_ParentSets[iAtt2].getNrOfParents()) {
                        order[iAtt] = iAtt2;
                        bDone[iAtt2] = true;
                        continue;
                    }
                    ++iAtt2;
                    continue;
                }
                ++iAtt2;
            }
            if (allParentsDone || iAtt2 != nNrOfAtts) continue;
            throw new Exception("There appears to be a cycle in the graph");
        }
        return order;
    }

    public String toString() {
        if (this.m_bGenerateNet) {
            return this.toXMLBIF03();
        }
        return this.m_Instances.toString();
    }

    void setNrOfNodes(int nNrOfNodes) {
        this.m_nNrOfNodes = nNrOfNodes;
    }

    void setNrOfArcs(int nNrOfArcs) {
        this.m_nNrOfArcs = nNrOfArcs;
    }

    void setNrOfInstances(int nNrOfInstances) {
        this.m_nNrOfInstances = nNrOfInstances;
    }

    void setCardinality(int nCardinality) {
        this.m_nCardinality = nCardinality;
    }

    void setSeed(int nSeed) {
        this.m_nSeed = nSeed;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(6);
        newVector.addElement(new Option("\tGenerate network (instead of instances)\n", "B", 0, "-B"));
        newVector.addElement(new Option("\tNr of nodes\n", "N", 1, "-N <integer>"));
        newVector.addElement(new Option("\tNr of arcs\n", "A", 1, "-A <integer>"));
        newVector.addElement(new Option("\tNr of instances\n", "M", 1, "-M <integer>"));
        newVector.addElement(new Option("\tCardinality of the variables\n", "C", 1, "-C <integer>"));
        newVector.addElement(new Option("\tSeed for random number generator\n", "S", 1, "-S <integer>"));
        newVector.addElement(new Option("\tThe BIF file to obtain the structure from.\n", "F", 1, "-F <file>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.m_bGenerateNet = Utils.getFlag('B', options);
        String sNrOfNodes = Utils.getOption('N', options);
        if (sNrOfNodes.length() != 0) {
            this.setNrOfNodes(Integer.parseInt(sNrOfNodes));
        } else {
            this.setNrOfNodes(10);
        }
        String sNrOfArcs = Utils.getOption('A', options);
        if (sNrOfArcs.length() != 0) {
            this.setNrOfArcs(Integer.parseInt(sNrOfArcs));
        } else {
            this.setNrOfArcs(10);
        }
        String sNrOfInstances = Utils.getOption('M', options);
        if (sNrOfInstances.length() != 0) {
            this.setNrOfInstances(Integer.parseInt(sNrOfInstances));
        } else {
            this.setNrOfInstances(10);
        }
        String sCardinality = Utils.getOption('C', options);
        if (sCardinality.length() != 0) {
            this.setCardinality(Integer.parseInt(sCardinality));
        } else {
            this.setCardinality(2);
        }
        String sSeed = Utils.getOption('S', options);
        if (sSeed.length() != 0) {
            this.setSeed(Integer.parseInt(sSeed));
        } else {
            this.setSeed(1);
        }
        String sBIFFile = Utils.getOption('F', options);
        if (sBIFFile != null && sBIFFile != "") {
            this.setBIFFile(sBIFFile);
        }
    }

    public String[] getOptions() {
        String[] options = new String[13];
        int current = 0;
        if (this.m_bGenerateNet) {
            options[current++] = "-B";
        }
        options[current++] = "-N";
        options[current++] = "" + this.m_nNrOfNodes;
        options[current++] = "-A";
        options[current++] = "" + this.m_nNrOfArcs;
        options[current++] = "-M";
        options[current++] = "" + this.m_nNrOfInstances;
        options[current++] = "-C";
        options[current++] = "" + this.m_nCardinality;
        options[current++] = "-S";
        options[current++] = "" + this.m_nSeed;
        if (this.m_sBIFFile.length() != 0) {
            options[current++] = "-F";
            options[current++] = "" + this.m_sBIFFile;
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    protected static void printOptions(OptionHandler o) {
        Enumeration enm = o.listOptions();
        System.out.println("Options for " + o.getClass().getName() + ":\n");
        while (enm.hasMoreElements()) {
            Option option = (Option)enm.nextElement();
            System.out.println(option.synopsis());
            System.out.println(option.description());
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        BayesNetGenerator b = new BayesNetGenerator();
        try {
            if (args.length == 0 || Utils.getFlag('h', args)) {
                BayesNetGenerator.printOptions(b);
                return;
            }
            b.setOptions(args);
            b.generateRandomNetwork();
            if (!b.m_bGenerateNet) {
                b.generateInstances();
            }
            System.out.println(b.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            BayesNetGenerator.printOptions(b);
        }
    }
}

