/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.Serializable;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class ParentSet
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = 4155021284407181838L;
    private int[] m_nParents;
    private int m_nNrOfParents = 0;
    private int m_nCardinalityOfParents = 1;

    public int getParent(int iParent) {
        return this.m_nParents[iParent];
    }

    public int[] getParents() {
        return this.m_nParents;
    }

    public void SetParent(int iParent, int nNode) {
        this.m_nParents[iParent] = nNode;
    }

    public int getNrOfParents() {
        return this.m_nNrOfParents;
    }

    public boolean contains(int iNode) {
        for (int iParent = 0; iParent < this.m_nNrOfParents; ++iParent) {
            if (this.m_nParents[iParent] != iNode) continue;
            return true;
        }
        return false;
    }

    public int getCardinalityOfParents() {
        return this.m_nCardinalityOfParents;
    }

    public int getFreshCardinalityOfParents(Instances _Instances) {
        this.m_nCardinalityOfParents = 1;
        for (int iParent = 0; iParent < this.m_nNrOfParents; ++iParent) {
            this.m_nCardinalityOfParents *= _Instances.attribute(this.m_nParents[iParent]).numValues();
        }
        return this.m_nCardinalityOfParents;
    }

    public ParentSet() {
        this.m_nParents = new int[10];
        this.m_nNrOfParents = 0;
        this.m_nCardinalityOfParents = 1;
    }

    public ParentSet(int nMaxNrOfParents) {
        this.m_nParents = new int[nMaxNrOfParents];
        this.m_nNrOfParents = 0;
        this.m_nCardinalityOfParents = 1;
    }

    public ParentSet(ParentSet other) {
        this.m_nNrOfParents = other.m_nNrOfParents;
        this.m_nCardinalityOfParents = other.m_nCardinalityOfParents;
        this.m_nParents = new int[this.m_nNrOfParents];
        for (int iParent = 0; iParent < this.m_nNrOfParents; ++iParent) {
            this.m_nParents[iParent] = other.m_nParents[iParent];
        }
    }

    public void maxParentSetSize(int nSize) {
        this.m_nParents = new int[nSize];
    }

    public void addParent(int nParent, Instances _Instances) {
        if (this.m_nNrOfParents == this.m_nParents.length) {
            int[] nParents = new int[2 * this.m_nParents.length];
            for (int i = 0; i < this.m_nNrOfParents; ++i) {
                nParents[i] = this.m_nParents[i];
            }
            this.m_nParents = nParents;
        }
        this.m_nParents[this.m_nNrOfParents] = nParent;
        ++this.m_nNrOfParents;
        this.m_nCardinalityOfParents *= _Instances.attribute(nParent).numValues();
    }

    public void addParent(int nParent, int iParent, Instances _Instances) {
        if (this.m_nNrOfParents == this.m_nParents.length) {
            int[] nParents = new int[2 * this.m_nParents.length];
            for (int i = 0; i < this.m_nNrOfParents; ++i) {
                nParents[i] = this.m_nParents[i];
            }
            this.m_nParents = nParents;
        }
        for (int iParent2 = this.m_nNrOfParents; iParent2 > iParent; --iParent2) {
            this.m_nParents[iParent2] = this.m_nParents[iParent2 - 1];
        }
        this.m_nParents[iParent] = nParent;
        ++this.m_nNrOfParents;
        this.m_nCardinalityOfParents *= _Instances.attribute(nParent).numValues();
    }

    public int deleteParent(int nParent, Instances _Instances) {
        int iParent;
        for (iParent = 0; this.m_nParents[iParent] != nParent && iParent < this.m_nNrOfParents; ++iParent) {
        }
        int iParent2 = -1;
        if (iParent < this.m_nNrOfParents) {
            iParent2 = iParent;
        }
        if (iParent < this.m_nNrOfParents) {
            while (iParent < this.m_nNrOfParents - 1) {
                this.m_nParents[iParent] = this.m_nParents[iParent + 1];
                ++iParent;
            }
            --this.m_nNrOfParents;
            this.m_nCardinalityOfParents /= _Instances.attribute(nParent).numValues();
        }
        return iParent2;
    }

    public void deleteLastParent(Instances _Instances) {
        --this.m_nNrOfParents;
        this.m_nCardinalityOfParents /= _Instances.attribute(this.m_nParents[this.m_nNrOfParents]).numValues();
    }

    public void copy(ParentSet other) {
        this.m_nCardinalityOfParents = other.m_nCardinalityOfParents;
        this.m_nNrOfParents = other.m_nNrOfParents;
        for (int iParent = 0; iParent < this.m_nNrOfParents; ++iParent) {
            this.m_nParents[iParent] = other.m_nParents[iParent];
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6942 $");
    }
}

