/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.xml.XMLClassifier;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.experiment.Experiment;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.JListHelper;
import weka.gui.PropertyDialog;

public class AlgorithmListPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -7204528834764898671L;
    protected Experiment m_Exp;
    protected JList m_List;
    protected JButton m_AddBut = new JButton("Add new...");
    protected JButton m_EditBut = new JButton("Edit selected...");
    protected JButton m_DeleteBut = new JButton("Delete selected");
    protected JButton m_LoadOptionsBut = new JButton("Load options...");
    protected JButton m_SaveOptionsBut = new JButton("Save options...");
    protected JButton m_UpBut = new JButton("Up");
    protected JButton m_DownBut = new JButton("Down");
    protected JFileChooser m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected FileFilter m_XMLFilter = new ExtensionFileFilter(".xml", "Classifier options (*.xml)");
    protected boolean m_Editing = false;
    protected GenericObjectEditor m_ClassifierEditor = new GenericObjectEditor(true);
    protected PropertyDialog m_PD;
    protected DefaultListModel m_AlgorithmListModel = new DefaultListModel();

    public AlgorithmListPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public AlgorithmListPanel() {
        final AlgorithmListPanel self = this;
        this.m_List = new JList();
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                final int index = AlgorithmListPanel.this.m_List.locationToIndex(e.getPoint());
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    if (index > -1) {
                        AlgorithmListPanel.this.actionPerformed(new ActionEvent(AlgorithmListPanel.this.m_EditBut, 0, ""));
                    }
                } else if (e.getClickCount() == 1 && (e.getButton() == 3 || e.getButton() == 1 && e.isAltDown() && e.isShiftDown())) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem item = new JMenuItem("Add configuration...");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String str = JOptionPane.showInputDialog(self, (Object)"Configuration (<classname> [<options>])");
                            if (str != null) {
                                try {
                                    String[] options = Utils.splitOptions(str);
                                    String classname = options[0];
                                    options[0] = "";
                                    Object obj = Utils.forName(Object.class, classname, options);
                                    AlgorithmListPanel.this.m_AlgorithmListModel.addElement(obj);
                                    AlgorithmListPanel.this.updateExperiment();
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    JOptionPane.showMessageDialog(self, "Error parsing commandline:\n" + ex, "Error...", 0);
                                }
                            }
                        }
                    });
                    menu.add(item);
                    if (AlgorithmListPanel.this.m_List.getSelectedValue() != null) {
                        menu.addSeparator();
                        item = new JMenuItem("Show properties...");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                self.actionPerformed(new ActionEvent(AlgorithmListPanel.this.m_EditBut, 0, ""));
                            }
                        });
                        menu.add(item);
                        item = new JMenuItem("Copy configuration to clipboard");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String str = AlgorithmListPanel.this.m_List.getSelectedValue().getClass().getName();
                                if (AlgorithmListPanel.this.m_List.getSelectedValue() instanceof OptionHandler) {
                                    str = str + " " + Utils.joinOptions(((OptionHandler)AlgorithmListPanel.this.m_List.getSelectedValue()).getOptions());
                                }
                                StringSelection selection = new StringSelection(str.trim());
                                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                                clipboard.setContents(selection, selection);
                            }
                        });
                        menu.add(item);
                        item = new JMenuItem("Enter configuration...");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String str = JOptionPane.showInputDialog(self, (Object)"Configuration (<classname> [<options>])");
                                if (str != null) {
                                    try {
                                        String[] options = Utils.splitOptions(str);
                                        String classname = options[0];
                                        options[0] = "";
                                        Object obj = Utils.forName(Object.class, classname, options);
                                        AlgorithmListPanel.this.m_AlgorithmListModel.setElementAt(obj, index);
                                        AlgorithmListPanel.this.updateExperiment();
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                        JOptionPane.showMessageDialog(self, "Error parsing commandline:\n" + ex, "Error...", 0);
                                    }
                                }
                            }
                        });
                        menu.add(item);
                    }
                    menu.show(AlgorithmListPanel.this.m_List, e.getX(), e.getY());
                }
            }
        };
        this.m_List.addMouseListener(mouseListener);
        this.m_ClassifierEditor.setClassType(Classifier.class);
        this.m_ClassifierEditor.setValue(new ZeroR());
        this.m_ClassifierEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AlgorithmListPanel.this.repaint();
            }
        });
        ((GenericObjectEditor.GOEPanel)this.m_ClassifierEditor.getCustomEditor()).addOkListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Classifier newCopy = (Classifier)AlgorithmListPanel.this.copyObject(AlgorithmListPanel.this.m_ClassifierEditor.getValue());
                AlgorithmListPanel.this.addNewAlgorithm(newCopy);
            }
        });
        this.m_DeleteBut.setEnabled(false);
        this.m_DeleteBut.addActionListener(this);
        this.m_AddBut.setEnabled(false);
        this.m_AddBut.addActionListener(this);
        this.m_EditBut.setEnabled(false);
        this.m_EditBut.addActionListener(this);
        this.m_LoadOptionsBut.setEnabled(false);
        this.m_LoadOptionsBut.addActionListener(this);
        this.m_SaveOptionsBut.setEnabled(false);
        this.m_SaveOptionsBut.addActionListener(this);
        this.m_UpBut.setEnabled(false);
        this.m_UpBut.addActionListener(this);
        this.m_DownBut.setEnabled(false);
        this.m_DownBut.addActionListener(this);
        this.m_List.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AlgorithmListPanel.this.setButtons(e);
            }
        });
        this.m_FileChooser.addChoosableFileFilter(this.m_XMLFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Algorithms"));
        JPanel topLab = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        topLab.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        topLab.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        topLab.add((Component)this.m_AddBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        topLab.add((Component)this.m_EditBut, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        topLab.add((Component)this.m_DeleteBut, constraints);
        JPanel bottomLab = new JPanel();
        gb = new GridBagLayout();
        constraints = new GridBagConstraints();
        bottomLab.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        bottomLab.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        bottomLab.add((Component)this.m_LoadOptionsBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        bottomLab.add((Component)this.m_SaveOptionsBut, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        bottomLab.add((Component)this.m_UpBut, constraints);
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        bottomLab.add((Component)this.m_DownBut, constraints);
        this.add((Component)topLab, "North");
        this.add((Component)new JScrollPane(this.m_List), "Center");
        this.add((Component)bottomLab, "South");
    }

    public void setExperiment(Experiment exp) {
        this.m_Exp = exp;
        this.m_AddBut.setEnabled(true);
        this.m_List.setModel(this.m_AlgorithmListModel);
        this.m_List.setCellRenderer(new ObjectCellRenderer());
        this.m_AlgorithmListModel.removeAllElements();
        if (this.m_Exp.getPropertyArray() instanceof Classifier[]) {
            Classifier[] algorithms;
            for (Classifier algorithm : algorithms = (Classifier[])this.m_Exp.getPropertyArray()) {
                this.m_AlgorithmListModel.addElement(algorithm);
            }
        }
        this.m_EditBut.setEnabled(this.m_AlgorithmListModel.size() > 0);
        this.m_DeleteBut.setEnabled(this.m_AlgorithmListModel.size() > 0);
        this.m_LoadOptionsBut.setEnabled(this.m_AlgorithmListModel.size() > 0);
        this.m_SaveOptionsBut.setEnabled(this.m_AlgorithmListModel.size() > 0);
        this.m_UpBut.setEnabled(JListHelper.canMoveUp(this.m_List));
        this.m_DownBut.setEnabled(JListHelper.canMoveDown(this.m_List));
    }

    private void addNewAlgorithm(Classifier newScheme) {
        if (!this.m_Editing) {
            this.m_AlgorithmListModel.addElement(newScheme);
        } else {
            this.m_AlgorithmListModel.setElementAt(newScheme, this.m_List.getSelectedIndex());
        }
        this.updateExperiment();
        this.m_Editing = false;
    }

    private void updateExperiment() {
        Classifier[] cArray = new Classifier[this.m_AlgorithmListModel.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (Classifier)this.m_AlgorithmListModel.elementAt(i);
        }
        this.m_Exp.setPropertyArray(cArray);
    }

    private void setButtons(ListSelectionEvent e) {
        if (e.getSource() == this.m_List) {
            this.m_DeleteBut.setEnabled(this.m_List.getSelectedIndex() > -1);
            this.m_AddBut.setEnabled(true);
            this.m_EditBut.setEnabled(this.m_List.getSelectedIndices().length == 1);
            this.m_LoadOptionsBut.setEnabled(this.m_List.getSelectedIndices().length == 1);
            this.m_SaveOptionsBut.setEnabled(this.m_List.getSelectedIndices().length == 1);
            this.m_UpBut.setEnabled(JListHelper.canMoveUp(this.m_List));
            this.m_DownBut.setEnabled(JListHelper.canMoveDown(this.m_List));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_AddBut) {
            this.m_Editing = false;
            if (this.m_PD == null) {
                int x = this.getLocationOnScreen().x;
                int y = this.getLocationOnScreen().y;
                this.m_PD = PropertyDialog.getParentDialog(this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(this), (PropertyEditor)this.m_ClassifierEditor, x, y) : new PropertyDialog(PropertyDialog.getParentFrame(this), (PropertyEditor)this.m_ClassifierEditor, x, y);
                this.m_PD.setVisible(true);
            } else {
                this.m_PD.setVisible(true);
            }
        } else if (e.getSource() == this.m_EditBut) {
            if (this.m_List.getSelectedValue() != null) {
                this.m_ClassifierEditor.setClassType(Classifier.class);
                this.m_ClassifierEditor.setValue(this.m_List.getSelectedValue());
                this.m_Editing = true;
                if (this.m_PD == null) {
                    int x = this.getLocationOnScreen().x;
                    int y = this.getLocationOnScreen().y;
                    this.m_PD = PropertyDialog.getParentDialog(this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(this), (PropertyEditor)this.m_ClassifierEditor, x, y) : new PropertyDialog(PropertyDialog.getParentFrame(this), (PropertyEditor)this.m_ClassifierEditor, x, y);
                    this.m_PD.setVisible(true);
                } else {
                    this.m_PD.setVisible(true);
                }
            }
        } else if (e.getSource() == this.m_DeleteBut) {
            int[] selected = this.m_List.getSelectedIndices();
            if (selected != null) {
                for (int i = selected.length - 1; i >= 0; --i) {
                    int current = selected[i];
                    this.m_AlgorithmListModel.removeElementAt(current);
                    if (this.m_Exp.getDatasets().size() > current) {
                        this.m_List.setSelectedIndex(current);
                        continue;
                    }
                    this.m_List.setSelectedIndex(current - 1);
                }
            }
            if (this.m_List.getSelectedIndex() == -1) {
                this.m_EditBut.setEnabled(false);
                this.m_DeleteBut.setEnabled(false);
                this.m_LoadOptionsBut.setEnabled(false);
                this.m_SaveOptionsBut.setEnabled(false);
                this.m_UpBut.setEnabled(false);
                this.m_DownBut.setEnabled(false);
            }
            this.updateExperiment();
        } else if (e.getSource() == this.m_LoadOptionsBut) {
            int returnVal;
            if (this.m_List.getSelectedValue() != null && (returnVal = this.m_FileChooser.showOpenDialog(this)) == 0) {
                try {
                    File file = this.m_FileChooser.getSelectedFile();
                    if (!file.getAbsolutePath().toLowerCase().endsWith(".xml")) {
                        file = new File(file.getAbsolutePath() + ".xml");
                    }
                    XMLClassifier xmlcls = new XMLClassifier();
                    Classifier c = (Classifier)xmlcls.read(file);
                    this.m_AlgorithmListModel.setElementAt(c, this.m_List.getSelectedIndex());
                    this.updateExperiment();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (e.getSource() == this.m_SaveOptionsBut) {
            int returnVal;
            if (this.m_List.getSelectedValue() != null && (returnVal = this.m_FileChooser.showSaveDialog(this)) == 0) {
                try {
                    File file = this.m_FileChooser.getSelectedFile();
                    if (!file.getAbsolutePath().toLowerCase().endsWith(".xml")) {
                        file = new File(file.getAbsolutePath() + ".xml");
                    }
                    XMLClassifier xmlcls = new XMLClassifier();
                    xmlcls.write(file, this.m_List.getSelectedValue());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (e.getSource() == this.m_UpBut) {
            JListHelper.moveUp(this.m_List);
            this.updateExperiment();
        } else if (e.getSource() == this.m_DownBut) {
            JListHelper.moveDown(this.m_List);
            this.updateExperiment();
        }
    }

    protected Object copyObject(Object source) {
        Object result = null;
        try {
            SerializedObject so = new SerializedObject(source);
            result = so.getObject();
        }
        catch (Exception ex) {
            System.err.println("AlgorithmListPanel: Problem copying object");
            System.err.println(ex);
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Algorithm List Editor");
            jf.getContentPane().setLayout(new BorderLayout());
            AlgorithmListPanel dp = new AlgorithmListPanel();
            jf.getContentPane().add((Component)dp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            System.err.println("Short nap");
            Thread.sleep(3000L);
            System.err.println("Done");
            dp.setExperiment(new Experiment());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }

    public class ObjectCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -5067138526587433808L;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String rep = value.getClass().getName();
            int dotPos = rep.lastIndexOf(46);
            if (dotPos != -1) {
                rep = rep.substring(dotPos + 1);
            }
            if (value instanceof OptionHandler) {
                rep = rep + " " + Utils.joinOptions(((OptionHandler)value).getOptions());
            }
            this.setText(rep);
            return c;
        }
    }
}

