% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estim.H0.VCC.R
\name{Estim.H0.VCC}
\alias{Estim.H0.VCC}
\title{Estimate the model parameters under the null model}
\usage{
Estim.H0.VCC(y, X, S, U)
}
\arguments{
\item{y}{Vector of phenotype values}

\item{X}{A matrix of covariates, including intercept.}

\item{S}{Matrix obtained from spectral decomposition of the
relationship matrix: \eqn{\Phi = U S U^T}.}

\item{U}{Matrix obtained from spectral decomposition of the
relationship matrix: \eqn{\Phi = U S U^T}.}
}
\value{
a list of:
\itemize{
\item \code{h.hat}: estimate of the (narrow sense) heritability
\item \code{gam.hat}: a vector of estimates of fixed effects of the covariates
(if there are any).
\item \code{residuals}: residuals from adjusting the null model
with only covariates in the model.
}
}
\description{
This function estimates the model parameters under the null model
when there is no region genotypes effect, for the VCC methods
}
\author{
Karim Oualkacha

M'Hamed Lajmi Lakhal-Chaieb
}

