\name{lr.multcomp}
\alias{lr.multcomp}
\alias{print.lr.multcomp}
\title{
Comparison of several simple linear least rectangles regression lines
}
\description{
Compare confidence intervals of parameters of several simple linear least rectangles regression lines. No test is performed, the function just compares confidence intervals and returns 'equal' or 'unequal'.
}
\usage{
lr.multcomp(formula, data, conf.level = 0.95)
}
\arguments{
  \item{formula}{
a formula of the form \code{y ~ x | f}, where \code{y} and \code{x} give the y and x variable, respectively, and \code{f} is a factor giving levels to be compared.
}
  \item{data}{
an optional data frame containing the variables in the formula \code{formula}. By default the variables are taken from \code{environment(formula)}.
}
  \item{conf.level}{
confidence level.
}
}
\value{
  \item{data.name}{a character string giving the name(s) of the data.}
  \item{conf.level}{confidence level.}
  \item{n.reg}{number of regression lines.}
  \item{intercepts}{intercept and confidence interval of each regression line.}
  \item{slopes}{slope and confidence interval of each regression lines.}
  \item{intercepts.comp}{table of results for intercepts.}
  \item{slopes.comp}{table of results for slopes.}
}
\author{
Maxime Herv <mx.herve@gmail.com>
}
\seealso{
\code{\link[RVAideMemoire]{least.rect}}
}
\examples{
x <- rep(1:30,3)
y <- c(1:30+rnorm(30,0,3),seq(10,35,25/29)+rnorm(30,0,3),seq(-27,0,27/29)+rnorm(30,0,3))
fact <- gl(3,30,labels=LETTERS[1:3])
lr.multcomp(y~x|fact)
}
