% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ManagePolygons.R
\name{ManagePolygons}
\alias{ManagePolygons}
\title{GUI: Polygon Manager}
\usage{
ManagePolygons(polys = NULL, poly.data = NULL, poly.crop = NULL,
  crs = sp::CRS(as.character(NA)), parent = NULL)
}
\arguments{
\item{polys}{list.
A list of polygons, components are objects of class \code{\link[=gpc.poly-class]{gpc.poly}}.}

\item{poly.data}{character.
Name of the polygon that defines the data boundary limits.}

\item{poly.crop}{character.
Name of the polygon that defines the crop region for interpolated data.}

\item{crs}{CRS.
Default coordinate reference system}

\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
Returns an object of class list with components
  \code{polys}, \code{poly.data}, \code{poly.crop}, and \code{crs} (see \sQuote{Arguments} section).
}
\description{
A graphical user interface (\acronym{GUI}) for managing and manipulating polygons
that is based on the \pkg{rgeos} package.
}
\details{
The text file representation of a polygon is of the following format:\cr\cr
  <number of contours>\cr
  <number of points in first contour>\cr
  <hole flag>\cr
  x1 y1\cr
  x2 y2\cr
  ...\cr
  <number of points in second contour>\cr
  <hole flag>\cr
  x1 y1\cr
  x2 y2\cr
  ...\cr\cr
  The hole flag is either 1 to indicate a hole, or 0 for a regular contour.
  See the \code{\link[rgeos:gpc-polyfile]{read.polyfile}} function for details.
}
\examples{
\dontrun{
  ManagePolygons()
}

}
\seealso{
\code{\link[rgeos:gpc-polyfile]{polyfile}}, \code{\link[rgeos:topo-bin-gUnion]{gUnion}},
  \code{\link[inlmisc]{SetPolygons}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{misc}
