% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatSRdata.R
\name{formatSRdata}
\alias{formatSRdata}
\title{formatSRdata}
\usage{
formatSRdata(data, value, imagerydate, samplingdate = "", location, datatype,
  qaband, qa_accept)
}
\arguments{
\item{data}{dataframe of surface reflectance data. Designed to work with reflectance values for bands from Landsat surface reflectance products (Blue, Red, Green, NIR, SWIR1, SWIR2, QA Band) at specific point locations}

\item{value}{string, name of column with water quality parameter values}

\item{imagerydate}{string, name of column for imagery dates (must be date format)}

\item{samplingdate}{string, name of column for sampling dates (only required if dataset is used for calibration, must be date format)}

\item{location}{string, name of column for location identifier}

\item{datatype}{string, "Calibration" or "Estimated"}

\item{qaband}{string, name of column for QA (such as a cloudmask) rating}

\item{qa_accept}{vector, QA classes which are acceptable}
}
\value{
dataframe with formatted data
}
\description{
Format surface reflectance data
}
\examples{
data(srdata)
formattedsrdata <- formatSRdata(data=srdata,value="FieldValue",imagerydate="ImageDate",
samplingdate="SamplingDate",location="StationID",
datatype="Calibration",qaband="CloudMask",qa_accept=c(0,1))
}
