% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRates.R
\name{plotRates}
\alias{plotRates}
\title{Plot RRphylo rates at a specified node}
\usage{
plotRates(RR,node,export.tiff=NULL,filename=NULL)
}
\arguments{
\item{RR}{an object produced by \code{\link{RRphylo}}.}

\item{node}{the node subtending the clade of interest.}

\item{export.tiff}{is deprecated.}

\item{filename}{is deprecated.}
}
\value{
The function returns a list of functions:

\strong{$plotHist} returns the histograms of rates (in ln absolute
 values) computed for the focal clade against rates computed the rest of the
 tree. The usage is:
 \code{...$plotHist(hist.args=list(col1,col2),legend.args=list())}, where
 \code{legend.args} is a list of additional arguments passed to the function
 \code{legend} (if \code{= NULL} the legend is not plotted) and
 \code{hist.args} is a list of further arguments passed to the function
 \code{plot.histogram}. \code{hist.args} default arguments include histogram
 colors for background rates (\code{col1}) and rates of the clade under
 inspection (\code{col2}).

\strong{$plotLollipop} returns the lollipop chart of the rates of
 individual branches of the focal clade collated in increasing rate value,
 and contrasted to the average rate computed over the rest of the tree
 branches (the vertical line). The usage is:
 \code{...$plotLollipop(lollipop.args=NULL,line.args=NULL)}, where
 \code{lollipop.args} is a list of further arguments passed to the function
 \code{\link{lollipoPlot}}  and \code{line.args} is a list of additional
 arguments passed to the function \code{line}. This function additionally
 returns the vector of rates for the focal clade, collated in increasing
 order.
}
\description{
This function generates customized functions to produce
 histograms and lollipop charts of the \code{\link{RRphylo}} rates computed
 for a given clade as compared to the rates computed for the rest of the
 tree.
}
\examples{
\donttest{
data("DataApes")
DataApes$PCstage->PCstage
DataApes$Tstage->Tstage
cc<- 2/parallel::detectCores()

RRphylo(tree=Tstage,y=PCstage,clus=cc)->RR

plotRates(RR,node=72)->pR
pR$plotHist(hist.args=list(col1="cyan1",col2="blue"),legend.args=list(x="topright"))
pR$plotLollipop(lollipop.args=list(col="chartreuse",bg="chartreuse"),
                line.args=list(col="deeppink",lwd=2))
}
}
\seealso{
\href{../doc/RRphylo.html}{\code{RRphylo} vignette}

\href{../doc/Plotting-tools.html}{\code{plotRates} vignette}

\href{../doc/RRphylo.html}{\code{RRphylo} vignette}

\href{../doc/Plotting-tools.html}{\code{plotRates} vignette}
}
\author{
Silvia Castiglione, Pasquale Raia
}
