% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRRR_class.R
\name{plot.RRRR}
\alias{plot.RRRR}
\title{Plot Objective value of a Robust Reduced-Rank Regression}
\usage{
\method{plot}{RRRR}(x, aes_x = c("iteration", "runtime"), xlog10 = TRUE, ...)
}
\arguments{
\item{x}{An RRRR object.}

\item{aes_x}{Either "iteration" or "runtime". The x axis in the plot.}

\item{xlog10}{Logical, indicates whether the scale of x axis is log 10 transformed.}

\item{...}{Additional argument to \code{ggplot2}.}
}
\value{
An ggplot2 object
}
\description{
Plot Objective value of a Robust Reduced-Rank Regression
}
\examples{
set.seed(2222)
data <- RRR_sim()
res <- RRRR(y=data$y, x=data$x, z = data$z)
plot(res)
}
\author{
Yangzhuoran Fin Yang
}
