% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.lm.rrpp.r
\name{predict.lm.rrpp}
\alias{predict.lm.rrpp}
\title{predict for lm.rrpp model fits}
\usage{
\method{predict}{lm.rrpp}(object, newdata, confidence = 0.95, ...)
}
\arguments{
\item{object}{Object from \code{\link{lm.rrpp}}.}

\item{newdata}{Data frame of either class \code{\link{data.frame}} or \code{\link{rrpp.data.frame}}.  If null,
the data frame from the lm.rrpp fit will be used, effectively calculating all fitted values and
their confidence intervals.}

\item{confidence}{The desired confidence interval level for prediction.}

\item{...}{Other arguments (currently none)}
}
\description{
Computes predicted values from an \code{\link{lm.rrpp}} model fit, using bootstrapped residuals
to generate confidence intervals.  (Residuals are the residuals of the lm.rppp fit, not its null model.  The bootstrap
procedure resamples residual vectors with replacement.)
The bootstrap permutations use the same number of iterations and seed as used
in the \code{\link{lm.rrpp}} model fit. A \code{\link{predict.lm.rrpp}} object can be plotted using various options.
See \code{\link{plot.predict.lm.rrpp}}.
}
\examples{
# See examples for lm.rrpp to see how predict.lm.rrpp works in conjunction
# with other functions

data(Pupfish)
names(Pupfish)
Pupfish$logSize <- log(Pupfish$CS) # better to not have functions in formulas

fit <- lm.rrpp(coords ~ logSize + Sex*Pop, SS.type = "I", data = Pupfish) 

# Predictions (holding alternative effects constant)

shapeDF <- expand.grid(Sex = levels(Pupfish$Sex), Pop = levels(Pupfish$Pop))
rownames(shapeDF) <- paste(shapeDF$Sex, shapeDF$Pop, sep = ".")
shapeDF

shapePreds <- predict(fit, shapeDF)
summary(shapePreds)
summary(shapePreds, PC = TRUE)

shapePreds99 <- predict(fit, shapeDF, confidence = 0.99)
summary(shapePreds99, PC = TRUE)

# Plot prediction

plot(shapePreds, PC = TRUE)
plot(shapePreds, PC = TRUE, ellipse = TRUE)
plot(shapePreds99, PC = TRUE)
plot(shapePreds99, PC = TRUE, ellipse = TRUE)
}
\author{
Michael Collyer
}
\keyword{utilities}
