% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.lm.rrpp.r
\name{coef.lm.rrpp}
\alias{coef.lm.rrpp}
\title{coef for lm.rrpp model fits}
\usage{
\method{coef}{lm.rrpp}(object, test = FALSE, confidence = 0.95, ...)
}
\arguments{
\item{object}{Object from \code{\link{lm.rrpp}}}

\item{test}{Logical argument that if TRUE, performs hypothesis tests (Null hypothesis is vector distance = 0)
for the observed coefficients.  If FALSE, only the observed coefficients are returned.}

\item{confidence}{The desired confidence interval level to print with a table of summary statistics,
if test = TRUE.}

\item{...}{Other arguments (currently none)}
}
\description{
Computes ordinary or generalized least squares coefficients
over the permutations of an \code{\link{lm.rrpp}} model fit with predefined random permutations.
For each coefficient vector, the Euclidean distance is calculated as an estimate of
the amount of change in Y, the n x p matrix of dependent variables; larger distances mean more change 
in location in the data space associated with a one unit change in the model design, for the parameter
described.  Random coefficients are based on either RRPP or FRPP, as defined by the 
\code{\link{lm.rrpp}} model fit.  If RRPP is used, all distributions of coefficient vector distances are 
based on appropriate null models as defined by SS type.
}
\examples{
# See examples for lm.rrpp to see how anova.lm.rrpp works in conjunction
# with other functions

data(Pupfish)
names(Pupfish)
Pupfish$logSize <- log(Pupfish$CS) # better to not have functions in formulas

fit <- lm.rrpp(coords ~ logSize + Sex*Pop, SS.type = "I", data = Pupfish) 

coef(fit)
coef(fit, confidence = 0.99)
}
\author{
Michael Collyer
}
\keyword{utilities}
