% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{find_algorithms}
\alias{find_algorithms}
\title{Find and list available QGIS algorithms}
\usage{
find_algorithms(search_term = NULL, name_only = FALSE,
  qgis_env = set_env())
}
\arguments{
\item{search_term}{If (\code{NULL}), the default, all available functions will be
returned. If \code{search_term} is a character, all available functions will be
queried accordingly. The character string might also contain a regular
expression (see examples).}

\item{name_only}{If \code{TRUE}, the function returns only the name(s) of the
found algorithms. Otherwise, a short function description will be returned
as well (default).}

\item{qgis_env}{Environment settings containing all the paths to run the QGIS
API. For more information, refer to \code{\link[=set_env]{set_env()}}.}
}
\value{
The function returns QGIS function names and short descriptions as an
R character vector.
}
\description{
\code{find_algorithms} lists or queries all QGIS algorithms which can
be accessed via the QGIS Python API.
}
\details{
Function \code{find_algorithms} simply calls \code{processing.alglist} using
Python.
}
\examples{
\dontrun{
# list all available QGIS algorithms on your system
algs <- find_algorithms()
algs[1:15]
# find a function which adds coordinates
find_algorithms(search_term = "add")
# find only QGIS functions
find_algorithms(search_term = "qgis:")
# find QGIS and SAGA functions related to centroid computations
find_algorithms(search_term = "centroid.+(qgis:|saga:)")
}
}
\author{
Jannes Muenchow, Victor Olaya, QGIS core team
}
