% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPhosFate.R
\name{emission,RPhosFate-method}
\alias{emission,RPhosFate-method}
\alias{emission}
\title{Emission}
\usage{
\S4method{emission}{RPhosFate}(x, substance = "PP")
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}

\item{substance}{A character string specifying the substance to calculate.}
}
\value{
An S4 \code{\linkS4class{RPhosFate}} river catchment object and side effects in
the form of raster files.
}
\description{
Calculates and writes substance emissions to disk.
}
\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)
# presupposed method calls
x <- erosionPrerequisites(x)
x <- erosion(x)

x <- emission(x, "PP")}

}
\seealso{
\code{\link{firstRun}}, \code{\link{subsequentRun}}
}
