% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPGMMClu.R
\name{RPGMMClu}
\alias{RPGMMClu}
\title{Random Projection Ensemble Clustering Algorithm}
\usage{
RPGMMClu(x, true.cl = NULL, g, d = NULL, c = 10, B = 1000,
  B.star = 100, modelNames = NULL, diagonal = FALSE,
  ensmethod = "DWH", seed = 101, verb = FALSE)
}
\arguments{
\item{x}{A numeric high-dimensional matrix where rows correspond to observations and columns correspond to variables.}

\item{true.cl}{A vector containing the true cluster membership. If supplied, the Adjusted Rand Index (ARI) of the predicted clustering is also returned. By default is set to NULL.}

\item{g}{The number of clusters.}

\item{d}{The dimension of the projected space. If is \code{NULL} (default option), then \eqn{d = \lceil c* log(g) \rceil.}{d = ceil(c* log(g)).}}

\item{c}{The constant which governs the dimension of the projected space if \eqn{d} is not provided. The default is set to 10.}

\item{B}{The number of generated projections; the default is 1000.}

\item{B.star}{The number of \emph{base} models to retain in the final ensemble; the default is 100.}

\item{modelNames}{A vector of character strings indicating the models to be fitted in the EM phase of the GMM. The help file for \link[mclust]{Mclust} describes the available options.}

\item{diagonal}{A logical value indicating whether the conditional covariate matrix has a restricted form, i.e. it is diagonal. The default is FALSE.}

\item{ensmethod}{A character string specifying the method for computing the clustering consensus. See the \link[clue]{cl_consensus} help file for available options. The default is \code{DWH}.}

\item{seed}{A single value indicating the initializing seed for random generations.}

\item{verb}{A logical controlling if the progress number of projections is displayed during the fitting procedure. By default is \code{FALSE}.}
}
\value{
The output components are as follows:
\item{\code{ensemble}}{A list including:
\describe{
 \item{\code{label.vec}}{The vector of labels predicted by the ensemble of size \code{B.star}.}
 \item{\code{ari}}{The corresponding ARI (if \code{true.cl} is not \code{NULL}).}}}
\item{individual}{A list including:
 \describe{\item{\code{label.vec}}{The vectors of labels predicted by each \emph{base} model.}
  \item{\code{ari}}{The corresponding ARI (if \code{true.cl} is not \code{NULL}).}
  \item{\code{bic}}{The BIC associated to each \emph{base} model.}
  \item{\code{bic.GMM}}{The BIC associated to the Gaussian mixture fitted on each projected data.}
  \item{\code{bic.reg}}{The BIC for the linear regression of the \eqn{(p-d)} last columns of \eqn{Y*} on the first \eqn{d} ones.}}}
}
\description{
This function allows to run the RPEClu algorithm.
}
\examples{
\donttest{
data(Meat)
out.clu <- RPGMMClu(Meat$x, Meat$y, g=5, B=1000, B.star=100, verb=TRUE)}

data <- sim_normal(n = rep(100, 2), p = 100, rho = rep(0.1, 2), delta = 0.5, sigma2 = 1, seed = 106)
out.clu <- RPGMMClu(data$x, data$y, g=2, B=10, B.star=5, verb=TRUE)

}
\references{
Anderlucci, Fortunato, Montanari (2019) <arXiv:1909.10832>
}
