% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.rv_mixture.R
\name{rv_mixture}
\alias{rv_mixture}
\title{rv_mixture}
\description{
rv_mixture distribution in OOP way.
}
\details{
No fit allowed.
}
\examples{
## Define the mixture
l_dist  = list( Exponential$new() , Normal$new( mean = 5 , sd = 1 ) )
weights = base::c( 0.2 , 0.8 )
rvX = rv_mixture$new( l_dist , weights )

## Draw samples
X   = rvX$rvs( 1000 )

}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{l_dist}}{[list]    List of distributions.}

\item{\code{n_dist}}{[integer] Numbers of distribution.}

\item{\code{weights}}{[vector]  Weights of the distributions.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{rv_mixture$new()}}
\item \href{#method-rvs}{\code{rv_mixture$rvs()}}
\item \href{#method-density}{\code{rv_mixture$density()}}
\item \href{#method-logdensity}{\code{rv_mixture$logdensity()}}
\item \href{#method-cdf}{\code{rv_mixture$cdf()}}
\item \href{#method-icdf}{\code{rv_mixture$icdf()}}
\item \href{#method-sf}{\code{rv_mixture$sf()}}
\item \href{#method-isf}{\code{rv_mixture$isf()}}
\item \href{#method-clone}{\code{rv_mixture$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new rv_mixture object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$new(l_dist, weights = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{l_dist}}{[list]    List of ROOPSD distributions.}

\item{\code{weights}}{[vector]  Weights of the distributions. If NULL,
1 / length(l_dist) is used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `rv_mixture` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rvs"></a>}}
\if{latex}{\out{\hypertarget{method-rvs}{}}}
\subsection{Method \code{rvs()}}{
Generation sample from the histogram
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$rvs(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{[integer] Number of samples drawn}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of samples
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-density"></a>}}
\if{latex}{\out{\hypertarget{method-density}{}}}
\subsection{Method \code{density()}}{
Density function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$density(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[vector] Values to compute the density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
density
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logdensity"></a>}}
\if{latex}{\out{\hypertarget{method-logdensity}{}}}
\subsection{Method \code{logdensity()}}{
Log density function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$logdensity(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[vector] Values to compute the log-density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the log density
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cdf"></a>}}
\if{latex}{\out{\hypertarget{method-cdf}{}}}
\subsection{Method \code{cdf()}}{
Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$cdf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
cdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-icdf"></a>}}
\if{latex}{\out{\hypertarget{method-icdf}{}}}
\subsection{Method \code{icdf()}}{
Inverse of Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$icdf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
icdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sf"></a>}}
\if{latex}{\out{\hypertarget{method-sf}{}}}
\subsection{Method \code{sf()}}{
Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$sf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
sf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isf"></a>}}
\if{latex}{\out{\hypertarget{method-isf}{}}}
\subsection{Method \code{isf()}}{
Inverse of Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$isf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
isf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rv_mixture$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
