% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.Gamma.R
\name{Gamma}
\alias{Gamma}
\title{Gamma}
\description{
Gamma distribution in OOP way. Based on AbstractDist
}
\details{
See AbstractDist for generic methods
}
\examples{
## Generate sample
scale = 1.5
shape = 0.5
gaml = ROOPSD::Gamma$new( scale = scale , shape = shape )
X    = gaml$rvs( n = 1000 )

## And fit parameters
gaml$fit(X)

}
\section{Super class}{
\code{\link[ROOPSD:AbstractDist]{ROOPSD::AbstractDist}} -> \code{Gamma}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{shape}}{[double] shape of the gamma law}

\item{\code{scale}}{[double] scale of the gamma law}

\item{\code{params}}{[vector] params of the gamma law}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Gamma$new()}}
\item \href{#method-clone}{\code{Gamma$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="cdf">}\href{../../ROOPSD/html/AbstractDist.html#method-cdf}{\code{ROOPSD::AbstractDist$cdf()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="density">}\href{../../ROOPSD/html/AbstractDist.html#method-density}{\code{ROOPSD::AbstractDist$density()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="fit">}\href{../../ROOPSD/html/AbstractDist.html#method-fit}{\code{ROOPSD::AbstractDist$fit()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="icdf">}\href{../../ROOPSD/html/AbstractDist.html#method-icdf}{\code{ROOPSD::AbstractDist$icdf()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="isf">}\href{../../ROOPSD/html/AbstractDist.html#method-isf}{\code{ROOPSD::AbstractDist$isf()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="logdensity">}\href{../../ROOPSD/html/AbstractDist.html#method-logdensity}{\code{ROOPSD::AbstractDist$logdensity()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="rvs">}\href{../../ROOPSD/html/AbstractDist.html#method-rvs}{\code{ROOPSD::AbstractDist$rvs()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="sf">}\href{../../ROOPSD/html/AbstractDist.html#method-sf}{\code{ROOPSD::AbstractDist$sf()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new Gamma object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gamma$new(shape = 0.5, scale = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{shape}}{[double] shape parameter}

\item{\code{scale}}{[double] scale parameter}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `Gamma` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gamma$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
