% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXTCOMP_datasets.R
\docType{data}
\name{titanic}
\alias{titanic}
\title{Titanic data set}
\format{
A data.frame with 1309 individuals and 8 variables.
\itemize{
  \item survived: 0 = No, 1 = Yes (factor)
  \item pclass:	ticket class 	1st, 2nd, 3rd (factor)
  \item sex: male or female (factor)
  \item age: age in years
  \item sibsp: number of siblings/spouses aboard the Titanic
  \item parch: number of parents/children aboard the Titanic 
  \item fare: ticket price in pounds
  \item embarked: port of Embarkation 	C = Cherbourg, Q = Queenstown, S = Southampton (factor)
}
}
\source{
Titanic People Database, Encyclopedia Titanica, \url{https://www.encyclopedia-titanica.org/titanic-survivors/}

\url{https://www.kaggle.com/c/titanic/data}
}
\usage{
data(titanic)
}
\description{
The data set provides information on the passengers of Titanic.
}
\examples{
\donttest{
data(titanic)

head(titanic)

## Use the MixtComp format
dat <- titanic

# refactor categorical data: survived, sex, embarked and pclass
dat$sex <- refactorCategorical(dat$sex, c("male", "female", NA), c(1, 2, "?"))
dat$embarked <- refactorCategorical(dat$embarked, c("C", "Q", "S", NA), c(1, 2, 3, "?"))
dat$survived <- refactorCategorical(dat$survived, c(0, 1, NA), c(1, 2, "?"))
dat$pclass <- refactorCategorical(dat$pclass, c("1st", "2nd", "3rd"), c(1, 2, 3))

# replace all NA by ?
dat[is.na(dat)] = "?" 

# create model
model <- list(pclass = "Multinomial",
              survived = "Multinomial",
              sex = "Multinomial",
              age = "Gaussian",
              sibsp = "Poisson",
              parch = "Poisson",
              fare = "Gaussian",
              embarked = "Multinomial")

# create algo
algo <- createAlgo()

# run clustering
resLearn <- mixtCompLearn(dat, model, algo, nClass = 2:15, criterion = "ICL", nRun = 3, nCore = 1)
summary(resLearn)

plot(resLearn) 


## Use standard data.frame and R format because titanic contains only standard variables.
# mixtCompLearn in "basic" mode without model parameters and data as a data.frame.
# A Multinomial model is used for factor variables, a Poisson for integer
# and a Gaussian for numeric.
resLearn <- mixtCompLearn(titanic, nClass = 2:15, nRun = 3, nCore = 1)

# imputed model
getType(resLearn)

}
  
}
\seealso{
Other data: 
\code{\link{CanadianWeather}},
\code{\link{prostate}},
\code{\link{simData}}
}
\concept{data}
\keyword{data}
