\docType{class}
\name{Kernel_C}
\alias{Kernel_C}
\alias{R6_Kernel_C}
\title{Kernel_C KEEL Classification Algorithm}
\description{
Kernel_C Classification Algorithm from KEEL. 
}
\usage{
Kernel_C(train, test, sigma, seed)
}
\arguments{
\item{train}{Train dataset as a data.frame object}
\item{test}{Test dataset as a data.frame object}
\item{sigma}{sigma. Default value = 0.01}
\item{seed}{Seed for random numbers. If it is not assigned a value, the seed will be a random number}
}
\value{
A data.frame with the actual and predicted classes for both \code{train} and \code{test} datasets.
}
\examples{
data_train <- RKEEL::loadKeelDataset("iris_train")
data_test <- RKEEL::loadKeelDataset("iris_test")

#Create algorithm
algorithm <- RKEEL::Kernel_C(data_train, data_test)

#Run algorithm
algorithm$run()

#See results
algorithm$testPredictions
}
\keyword{classification}

