/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.rules.ZeroR;
import weka.core.Check;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class CheckOptionHandler
extends Check {
    protected OptionHandler m_OptionHandler = new ZeroR();
    protected String[] m_UserOptions = new String[0];
    protected boolean m_Success;

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tFull name of the OptionHandler analysed.\n\teg: weka.classifiers.rules.ZeroR\n\t(default weka.classifiers.rules.ZeroR)", "W", 1, "-W"));
        if (this.m_OptionHandler != null) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to option handler " + this.m_OptionHandler.getClass().getName() + ":"));
            Enumeration enumeration2 = this.m_OptionHandler.listOptions();
            while (enumeration2.hasMoreElements()) {
                vector.addElement(enumeration2.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            string = ZeroR.class.getName();
        }
        this.setUserOptions(Utils.partitionOptions(stringArray));
        this.setOptionHandler((OptionHandler)Utils.forName(OptionHandler.class, string, null));
    }

    public String[] getOptions() {
        int n;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        if (this.getOptionHandler() != null) {
            vector.add("-W");
            vector.add(this.getOptionHandler().getClass().getName());
        }
        if (this.m_OptionHandler != null) {
            stringArray = this.m_OptionHandler.getOptions();
            vector.add("--");
            for (n = 0; n < stringArray.length; ++n) {
                vector.add(stringArray[n]);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptionHandler(OptionHandler optionHandler) {
        this.m_OptionHandler = optionHandler;
    }

    public OptionHandler getOptionHandler() {
        return this.m_OptionHandler;
    }

    public void setUserOptions(String[] stringArray) {
        this.m_UserOptions = this.getCopy(stringArray);
    }

    public String[] getUserOptions() {
        return this.getCopy(this.m_UserOptions);
    }

    public boolean getSuccess() {
        return this.m_Success;
    }

    protected String printOptions(String[] stringArray) {
        if (stringArray == null) {
            return "<null>";
        }
        return Utils.joinOptions(stringArray);
    }

    protected void compareOptions(String[] stringArray, String[] stringArray2) throws Exception {
        if (stringArray == null) {
            throw new Exception("first set of options is null!");
        }
        if (stringArray2 == null) {
            throw new Exception("second set of options is null!");
        }
        if (stringArray.length != stringArray2.length) {
            throw new Exception("problem found!\nFirst set: " + this.printOptions(stringArray) + '\n' + "Second set: " + this.printOptions(stringArray2) + '\n' + "options differ in length");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            throw new Exception("problem found!\n\tFirst set: " + this.printOptions(stringArray) + '\n' + "\tSecond set: " + this.printOptions(stringArray2) + '\n' + '\t' + stringArray[i] + " != " + stringArray2[i]);
        }
    }

    protected String[] getCopy(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    protected OptionHandler getDefaultHandler() {
        OptionHandler optionHandler;
        try {
            optionHandler = (OptionHandler)this.m_OptionHandler.getClass().newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            optionHandler = null;
        }
        return optionHandler;
    }

    protected String[] getDefaultOptions() {
        String[] stringArray;
        OptionHandler optionHandler = this.getDefaultHandler();
        if (optionHandler == null) {
            this.println("WARNING: couldn't create default handler, cannot use default options!");
            stringArray = new String[]{};
        } else {
            stringArray = optionHandler.getOptions();
        }
        return stringArray;
    }

    public boolean checkListOptions() {
        boolean bl;
        block4: {
            this.print("ListOptions...");
            try {
                Enumeration enumeration = this.getOptionHandler().listOptions();
                if (this.getDebug() && enumeration.hasMoreElements()) {
                    this.println("");
                }
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    if (!this.getDebug()) continue;
                    this.println(option.synopsis());
                    this.println(option.description());
                }
                this.println("yes");
                bl = true;
            }
            catch (Exception exception) {
                this.println("no");
                bl = false;
                if (!this.getDebug()) break block4;
                this.println(exception);
            }
        }
        return bl;
    }

    public boolean checkSetOptions() {
        boolean bl;
        block2: {
            this.print("SetOptions...");
            try {
                this.getDefaultHandler().setOptions(this.getUserOptions());
                this.println("yes");
                bl = true;
            }
            catch (Exception exception) {
                this.println("no");
                bl = false;
                if (!this.getDebug()) break block2;
                this.println(exception);
            }
        }
        return bl;
    }

    public boolean checkRemainingOptions() {
        boolean bl;
        block3: {
            this.print("Remaining options...");
            String[] stringArray = this.getUserOptions();
            try {
                this.getDefaultHandler().setOptions(stringArray);
                if (this.getDebug()) {
                    this.println("\n  remaining: " + this.printOptions(stringArray));
                }
                this.println("yes");
                bl = true;
            }
            catch (Exception exception) {
                this.println("no");
                bl = false;
                if (!this.getDebug()) break block3;
                this.println(exception);
            }
        }
        return bl;
    }

    public boolean checkCanonicalUserOptions() {
        boolean bl;
        block6: {
            this.print("Canonical user options...");
            try {
                OptionHandler optionHandler = this.getDefaultHandler();
                optionHandler.setOptions(this.getUserOptions());
                if (this.getDebug()) {
                    this.print("\n  Getting canonical user options: ");
                }
                String[] stringArray = optionHandler.getOptions();
                if (this.getDebug()) {
                    this.println(this.printOptions(stringArray));
                }
                if (this.getDebug()) {
                    this.println("  Setting canonical user options");
                }
                optionHandler.setOptions((String[])stringArray.clone());
                if (this.getDebug()) {
                    this.println("  Checking canonical user options");
                }
                String[] stringArray2 = optionHandler.getOptions();
                this.compareOptions(stringArray, stringArray2);
                this.println("yes");
                bl = true;
            }
            catch (Exception exception) {
                this.println("no");
                bl = false;
                if (!this.getDebug()) break block6;
                this.println(exception);
            }
        }
        return bl;
    }

    public boolean checkResettingOptions() {
        boolean bl;
        block5: {
            this.print("Resetting options...");
            try {
                if (this.getDebug()) {
                    this.println("\n  Setting user options");
                }
                OptionHandler optionHandler = this.getDefaultHandler();
                optionHandler.setOptions(this.getUserOptions());
                String[] stringArray = this.getDefaultOptions();
                if (this.getDebug()) {
                    this.println("  Resetting to default options");
                }
                optionHandler.setOptions(this.getCopy(stringArray));
                if (this.getDebug()) {
                    this.println("  Checking default options match previous default");
                }
                String[] stringArray2 = optionHandler.getOptions();
                this.compareOptions(stringArray, stringArray2);
                this.println("yes");
                bl = true;
            }
            catch (Exception exception) {
                this.println("no");
                bl = false;
                if (!this.getDebug()) break block5;
                this.println(exception);
            }
        }
        return bl;
    }

    public void doTests() {
        this.println("OptionHandler: " + this.m_OptionHandler.getClass().getName() + "\n");
        if (this.getDebug()) {
            this.println("--> Info");
            this.print("Default options: ");
            this.println(this.printOptions(this.getDefaultOptions()));
            this.print("User options: ");
            this.println(this.printOptions(this.getUserOptions()));
        }
        this.println("--> Tests");
        this.m_Success = this.checkListOptions();
        if (this.m_Success) {
            this.m_Success = this.checkSetOptions();
        }
        if (this.m_Success) {
            this.m_Success = this.checkRemainingOptions();
        }
        if (this.m_Success) {
            this.m_Success = this.checkCanonicalUserOptions();
        }
        if (this.m_Success) {
            this.m_Success = this.checkResettingOptions();
        }
    }

    public static void main(String[] stringArray) {
        CheckOptionHandler checkOptionHandler = new CheckOptionHandler();
        CheckOptionHandler.runCheck(checkOptionHandler, stringArray);
        if (checkOptionHandler.getSuccess()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }
}

