/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsFormatter;
import com.hp.hpl.jena.shared.Command;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.vocabulary.ResultSet;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class rdfquery {
    public static boolean displayTime = false;
    public static int messageLevel = 0;
    public static boolean debug = false;
    public static boolean dumpModel = false;
    static final int FMT_NONE = -1;
    static final int FMT_TUPLES = 0;
    static final int FMT_TEXT = 1;
    static final int FMT_HTML = 2;
    static final int FMT_DUMP = 3;
    public static int outputFormat = 1;
    static String dbUser = "";
    static String dbPassword = "";
    static String dbType = "";
    static String dbName = "";
    static String dbDriver = null;
    static String vocabularyURI = null;
    static Model vocabulary = null;
    static boolean applyRDFS = false;
    protected static Log logger = LogFactory.getLog((Class)rdfquery.class);

    public static void main(String[] argv) throws Exception {
        String arg;
        int argi;
        System.err.println("Use of the old RDQL engine is deprecated - try the command jena.sparql");
        if (argv.length == 0) {
            rdfquery.usage();
            System.exit(0);
        }
        String dataURL = null;
        String language = null;
        String queryFile = null;
        displayTime = false;
        for (argi = 0; argi < argv.length && (arg = argv[argi]).startsWith("-"); ++argi) {
            if (!arg.startsWith("--")) {
                arg = "-" + arg;
            }
            if (arg.equalsIgnoreCase("--test")) {
                if (++argi == argv.length) {
                    rdfquery.allTests();
                    System.exit(0);
                    continue;
                }
                rdfquery.doTests(argv[argi]);
                System.exit(0);
                continue;
            }
            if (arg.equalsIgnoreCase("--help") || arg.equalsIgnoreCase("--h")) {
                rdfquery.usage();
                System.exit(0);
                continue;
            }
            if (arg.equalsIgnoreCase("--debug")) {
                debug = true;
                continue;
            }
            if (arg.equalsIgnoreCase("--quiet") || arg.equalsIgnoreCase("--q")) {
                --messageLevel;
                continue;
            }
            if (arg.equalsIgnoreCase("--verbose") || arg.equalsIgnoreCase("--v")) {
                ++messageLevel;
                continue;
            }
            if (arg.equalsIgnoreCase("--format") || arg.equalsIgnoreCase("--fmt")) {
                if (++argi == argv.length) {
                    System.err.println("Error: no output format given");
                    System.exit(1);
                }
                if ((arg = argv[argi]).equalsIgnoreCase("none")) {
                    outputFormat = -1;
                    continue;
                }
                if (arg.equalsIgnoreCase("tuples")) {
                    outputFormat = 0;
                    continue;
                }
                if (arg.equalsIgnoreCase("tuple")) {
                    outputFormat = 0;
                    continue;
                }
                if (arg.equalsIgnoreCase("text")) {
                    outputFormat = 1;
                    continue;
                }
                if (arg.equalsIgnoreCase("html")) {
                    outputFormat = 2;
                    continue;
                }
                if (arg.equalsIgnoreCase("dump")) {
                    outputFormat = 3;
                    continue;
                }
                System.err.println("Unrecognized output format: " + arg);
                System.exit(1);
                continue;
            }
            if (arg.equalsIgnoreCase("--vocabulary") || arg.equalsIgnoreCase("--vocab")) {
                if (++argi == argv.length) {
                    System.err.println("Error: no vocabulary specified");
                    System.exit(1);
                }
                vocabularyURI = argv[argi];
                continue;
            }
            if (arg.equalsIgnoreCase("--rdfs")) {
                applyRDFS = true;
                continue;
            }
            if (arg.equalsIgnoreCase("--time")) {
                displayTime = true;
                continue;
            }
            if (arg.equalsIgnoreCase("--xml")) {
                language = "RDF/XML";
                continue;
            }
            if (arg.equalsIgnoreCase("--ntriple")) {
                language = "N-TRIPLE";
                continue;
            }
            if (arg.equalsIgnoreCase("--n3")) {
                language = "N3";
                continue;
            }
            if (arg.equalsIgnoreCase("--bdb")) {
                language = "RDF/BDB";
                continue;
            }
            if (arg.equalsIgnoreCase("--dbName")) {
                if (++argi == argv.length) {
                    System.err.println("Error: no database name  specified");
                    System.exit(1);
                }
                dbName = argv[argi];
                continue;
            }
            if (arg.equalsIgnoreCase("--dbType")) {
                if (++argi == argv.length) {
                    System.err.println("Error: no database type  specified");
                    System.exit(1);
                }
                dbType = argv[argi];
                continue;
            }
            if (arg.equalsIgnoreCase("--driver")) {
                if (++argi == argv.length) {
                    System.err.println("Error: no driver specified");
                    System.exit(1);
                }
                dbDriver = argv[argi];
                continue;
            }
            if (arg.equalsIgnoreCase("--user")) {
                if (++argi == argv.length) {
                    System.err.println("Error: no user name  specified");
                    System.exit(1);
                }
                dbUser = argv[argi];
                continue;
            }
            if (arg.equalsIgnoreCase("--password")) {
                if (++argi == argv.length) {
                    System.err.println("Error: no password  specified");
                    System.exit(1);
                }
                dbPassword = argv[argi];
                continue;
            }
            if (arg.equalsIgnoreCase("--data")) {
                if (dataURL != null) {
                    System.err.println("Error: source already specified");
                    System.exit(1);
                }
                if (++argi == argv.length) {
                    System.err.println("Error: no data file specified");
                    System.exit(1);
                }
                dataURL = argv[argi];
                continue;
            }
            if (arg.equalsIgnoreCase("--query")) {
                if (++argi == argv.length) {
                    System.err.println("Error: no query file specified");
                    System.exit(1);
                }
                queryFile = argv[argi];
                continue;
            }
            System.err.println("Unrecognized option: " + arg);
            rdfquery.usage();
            System.exit(1);
        }
        if (messageLevel >= 3) {
            dumpModel = true;
        }
        String queryString = null;
        if (queryFile != null) {
            try {
                queryString = FileUtils.readWholeFileAsUTF8(queryFile);
            }
            catch (Exception e) {
                System.err.println("Error: failed to read file: " + e);
                System.exit(1);
            }
        } else {
            if (argi >= argv.length) {
                System.err.println("Error: No query supplied");
                System.exit(1);
            }
            queryString = argv[argi];
        }
        rdfquery.query(queryString, dataURL, language);
    }

    static void allTests() throws Exception {
        rdfquery.doTests("-all");
    }

    public static void doTests(String testsFilename) throws Exception {
        Class<?> rdfparse2 = Class.forName("jena.test.rdfquery");
        Constructor<?> constructor = rdfparse2.getConstructor(String.class);
        Command c = (Command)constructor.newInstance(testsFilename);
        c.execute();
    }

    public static void query(String s, String dataURL, String language) {
        try {
            PrintWriter pw;
            boolean doBlank = false;
            if (messageLevel >= 2) {
                System.out.println("Query:");
                System.out.println(s);
                if (!s.endsWith("\n")) {
                    System.out.println();
                }
                doBlank = true;
            }
            long startTime = System.currentTimeMillis();
            long loadTime = -1L;
            Query query2 = new Query(s);
            if (displayTime) {
                query2 = new Query(s);
            }
            if (messageLevel > 0) {
                System.out.println("Parsed query:");
                String tmp = query2.toString();
                System.out.print(tmp);
                if (!tmp.endsWith("\n")) {
                    System.out.println();
                }
                doBlank = true;
            }
            if (dataURL == null && query2.getSourceURL() == null) {
                System.err.println("RDQL: no data source");
                return;
            }
            if (dataURL != null) {
                long startLoadTime = System.currentTimeMillis();
                query2.setSource(ModelLoader.loadModel(dataURL, language, dbUser, dbPassword, dbName, dbType, dbDriver));
                if (query2.getSource() instanceof ModelRDB) {
                    ModelRDB model = (ModelRDB)query2.getSource();
                    model.setQueryOnlyAsserted(true);
                    model.setDoFastpath(true);
                }
                Model m = query2.getSource();
                if (applyRDFS) {
                    InfModel model = null;
                    if (vocabularyURI != null) {
                        vocabulary = FileManager.get().loadModel(vocabularyURI, null);
                        model = ModelFactory.createRDFSModel(m, vocabulary);
                    } else {
                        model = ModelFactory.createRDFSModel(m);
                    }
                    query2.setSource(model);
                }
                query2.loadTime = loadTime = System.currentTimeMillis() - startLoadTime;
            }
            if (query2.getSource() != null) {
                query2.getSource().begin();
            }
            QueryEngine qe = new QueryEngine(query2);
            qe.init();
            if (dumpModel) {
                try {
                    if (doBlank) {
                        System.out.println();
                    }
                    doBlank = true;
                    Model model = query2.getSource();
                    RDFWriter w = model.getWriter("N-TRIPLE");
                    pw = new PrintWriter(System.out);
                    pw.println("# Model --------------------------------------------------------------------------------");
                    w.write(model, pw, "http://unset/");
                    pw.println("# Model --------------------------------------------------------------------------------");
                    pw.flush();
                }
                catch (JenaException refEx) {
                    logger.error((Object)"rdfquery: Failed to write model");
                    System.exit(1);
                }
            }
            QueryResults results = qe.exec();
            QueryResultsFormatter fmt = new QueryResultsFormatter(results);
            if (outputFormat == -1) {
                fmt.consume();
            } else {
                if (doBlank) {
                    System.out.println();
                }
                if (outputFormat == 3) {
                    Model m = fmt.toModel();
                    RDFWriter rdfw = m.getWriter("N3");
                    m.setNsPrefix("rs", ResultSet.getURI());
                    rdfw.write(m, System.out, null);
                } else {
                    pw = new PrintWriter(System.out);
                    switch (outputFormat) {
                        case 1: {
                            fmt.printAll(pw);
                            break;
                        }
                        case 2: {
                            fmt.printHTML(pw);
                            break;
                        }
                        case 0: {
                            fmt.dump(pw, true);
                            break;
                        }
                    }
                    pw.flush();
                }
                doBlank = true;
            }
            fmt.close();
            results.close();
            qe.close();
            if (query2.getSource() != null) {
                query2.getSource().commit();
            }
            long finishTime = System.currentTimeMillis();
            long totalTime = finishTime - startTime;
            if (messageLevel > 0) {
                if (doBlank) {
                    System.out.println();
                }
                System.out.println("Results: " + fmt.numRows());
                doBlank = true;
            }
            if (displayTime) {
                if (doBlank) {
                    System.out.println();
                }
                System.out.println("Query parse:     " + rdfquery.formatlong(query2.parseTime) + " ms");
                System.out.println("Query build:     " + rdfquery.formatlong(query2.buildTime) + " ms");
                System.out.println("Data load time:  " + rdfquery.formatlong(query2.loadTime) + " ms");
                System.out.println("Query execute:   " + rdfquery.formatlong(query2.executeTime) + " ms");
                System.out.println("Query misc:      " + rdfquery.formatlong(totalTime - query2.parseTime - query2.buildTime - query2.loadTime - query2.executeTime) + " ms");
                System.out.println("Query total:     " + rdfquery.formatlong(totalTime) + " ms");
                doBlank = true;
            }
            if (query2.getSource() != null) {
                query2.getSource().close();
            }
        }
        catch (QueryException qEx) {
            System.err.println(qEx.getMessage());
            System.exit(9);
        }
    }

    static String formatlong(long x) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(Long.toString(x));
        for (int i = sbuff.length(); i < 4; ++i) {
            sbuff.append(" ");
        }
        return sbuff.toString();
    }

    static void usage() {
        System.out.println("Usage: [--rdfs] [--data URL] [queryString | --query file]");
        System.out.println("   --query file         Read one query from a file");
        System.out.println("   --rdfs               Use an RDFS reasoner around the data");
        System.out.println("   --vocab URL | File   Specify a separate vocabulary (may also be in the data)");
        System.out.println("   --xml                Data source is XML (default)");
        System.out.println("   --ntriple            Data source is n-triple");
        System.out.println("   --n3                 Data source is N3");
        System.out.println("   --data URL           Data source (can also be part of query)");
        System.out.println("   --time               Print some time information");
        System.out.println("   --test [file]        Run the test suite");
        System.out.println("   --format FMT         One of text, html, tuples, dump or none");
        System.out.println("   --verbose            Verbose - more messages");
        System.out.println("   --quiet              Quiet - less messages");
    }
}

