/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.BaseObservation;
import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.GenericSDMXClient;
import it.bancaditalia.oss.sdmx.api.PortableDataSet;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.api.SDMXReference;
import it.bancaditalia.oss.sdmx.api.SDMXVersion;
import it.bancaditalia.oss.sdmx.api.SdmxAttribute;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.SDMXClientFactory;
import it.bancaditalia.oss.sdmx.client.custom.RestSdmx20Client;
import it.bancaditalia.oss.sdmx.exceptions.DataStructureException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxUnknownProviderException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LoginDialog;
import java.awt.Frame;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JFrame;

public class SdmxClientHandler {
    protected static final Logger LOGGER = Configuration.getSdmxLogger();
    private static final String sourceClass = SdmxClientHandler.class.getSimpleName();
    private static Map<String, GenericSDMXClient> clients = new HashMap<String, GenericSDMXClient>();

    public static boolean needsCredentials(String string) throws SdmxException {
        return SdmxClientHandler.getClient(string).needsCredentials();
    }

    public static void setCredentials(String string, String string2, String string3) throws SdmxException {
        SdmxClientHandler.getClient(string, string2, string3);
    }

    public static void setPreferredLanguage(String string) throws SdmxException {
        Configuration.setLanguages(string);
    }

    public static void addLocalProvider(String string, String string2, String string3) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null) {
            LOGGER.severe("The enpoint of the provider cannot be null");
            throw new SdmxInvalidParameterException("The endpoint of the provider cannot be null");
        }
        File file = new File(string2);
        if (!file.isDirectory()) {
            LOGGER.severe("The enpoint of the provider must be an existing local directory");
            throw new SdmxInvalidParameterException("The enpoint of the provider has to be an existing local directory");
        }
        SDMXClientFactory.addProvider(string, file.toURI(), false, false, false, string3, SDMXVersion.V2);
    }

    public static void addProvider(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3, SDMXVersion sDMXVersion) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null) {
            LOGGER.severe("The enpoint of the provider cannot be null");
            throw new SdmxInvalidParameterException("The endpoint of the provider cannot be null");
        }
        try {
            SDMXClientFactory.addProvider(string, new URI(string2), bl, bl2, bl3, string3, sDMXVersion);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SdmxInvalidParameterException(uRISyntaxException.getMessage());
        }
    }

    public static SortedMap<String, Boolean> getProviders() {
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        for (Map.Entry entry : SDMXClientFactory.getProviders().entrySet()) {
            treeMap.put((String)entry.getKey(), ((Provider)entry.getValue()).isNeedsCredentials());
        }
        return treeMap;
    }

    public static DataFlowStructure getDataFlowStructure(String string, String string2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null || string2.trim().isEmpty()) {
            LOGGER.severe("The name of the dataflow cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        DataFlowStructure dataFlowStructure = null;
        SDMXReference sDMXReference = SdmxClientHandler.getDSDIdentifier(string, string2);
        String string3 = sDMXReference.getFullIdentifier();
        Provider provider = SdmxClientHandler.getProvider(string);
        dataFlowStructure = provider.getDSD(string3);
        if (dataFlowStructure == null) {
            LOGGER.finer("DSD for " + sDMXReference.getFullIdentifier() + " not cached. Calling Provider.");
            dataFlowStructure = SdmxClientHandler.getClient(string).getDataFlowStructure(sDMXReference, true);
            if (dataFlowStructure != null) {
                if (!(SdmxClientHandler.getClient(string) instanceof RestSdmx20Client)) {
                    Codelist codelist;
                    for (Dimension sdmxMetaElement : dataFlowStructure.getDimensions()) {
                        codelist = sdmxMetaElement.getCodeList();
                        if (codelist == null || !codelist.isEmpty()) continue;
                        Codelist codelist2 = SdmxClientHandler.getClient(string).getCodes(codelist);
                        if (codelist2 == null || codelist2.isEmpty()) {
                            throw new SdmxXmlContentException("Could not find codelist  for '" + codelist + "' in provider: '" + string + "'");
                        }
                        sdmxMetaElement.setCodeList(codelist2);
                        dataFlowStructure.setDimension(sdmxMetaElement);
                    }
                    for (SdmxAttribute sdmxAttribute : dataFlowStructure.getAttributes()) {
                        codelist = sdmxAttribute.getCodeList();
                        if (codelist == null || !codelist.isEmpty()) continue;
                        sdmxAttribute.setCodeList(SdmxClientHandler.getClient(string).getCodes(codelist));
                        dataFlowStructure.setAttribute(sdmxAttribute);
                    }
                }
                provider.setDSD(string3, dataFlowStructure);
            } else {
                throw new SdmxXmlContentException("Could not find dataflow structure for '" + string2 + "' in provider: '" + string + "'");
            }
        }
        return dataFlowStructure;
    }

    public static SDMXReference getDSDIdentifier(String string, String string2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null || string2.trim().isEmpty()) {
            LOGGER.severe("The name of the dataflow cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        Provider provider = SdmxClientHandler.getProvider(string);
        SDMXReference sDMXReference = null;
        sDMXReference = provider.getDSDIdentifier(string2);
        if (sDMXReference == null) {
            LOGGER.finer("DSD identifier for dataflow " + string2 + " not cached. Calling Provider.");
            Dataflow dataflow = SdmxClientHandler.getClient(string).getDataflow(string2, null, null);
            if (dataflow != null) {
                provider.setFlow(dataflow);
                sDMXReference = dataflow.getDsdIdentifier();
                if (sDMXReference == null) {
                    throw new SdmxXmlContentException("Could not get DSD identifier for dataflow '" + string2 + "' in provider: '" + provider.getName() + "'");
                }
            } else {
                throw new SdmxXmlContentException("Could not get dataflow '" + string2 + "' in provider: '" + string + "'");
            }
        }
        return sDMXReference;
    }

    public static List<Dimension> getDimensions(String string, String string2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null || string2.trim().isEmpty()) {
            LOGGER.severe("The name of the dataflow cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        return SdmxClientHandler.getDataFlowStructure(string, string2).getDimensions();
    }

    public static Map<String, Map<String, String>> filterCodes(String string, String string2, String string3) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null || string2.trim().isEmpty()) {
            LOGGER.severe("The name of the dataflow cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        LinkedHashMap<String, Map<String, String>> linkedHashMap = new LinkedHashMap<String, Map<String, String>>();
        Dataflow dataflow = SdmxClientHandler.getFlow(string, string2);
        DataFlowStructure dataFlowStructure = SdmxClientHandler.getDataFlowStructure(string, string2);
        Map<String, List<String>> map = SdmxClientHandler.getClient(string).getAvailableCubeRegion(dataflow, string3, "available");
        if (map.size() == dataFlowStructure.getDimensions().size()) {
            for (Dimension dimension : dataFlowStructure.getDimensions()) {
                Map<String, String> map2 = SdmxClientHandler.getCodes(string, string2, dimension.getId()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                map2.keySet().retainAll((Collection)map.get(dimension.getId()));
                linkedHashMap.put(dimension.getId(), map2);
            }
            return linkedHashMap;
        }
        throw new SdmxInvalidParameterException("The filter returned and empty cube region");
    }

    public static Map<String, Integer> getSeriesCount(String string, String string2, String string3) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null || string2.trim().isEmpty()) {
            LOGGER.severe("The name of the dataflow cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        Dataflow dataflow = SdmxClientHandler.getFlow(string, string2);
        return SdmxClientHandler.getClient(string).getAvailableTimeSeriesNumber(dataflow, string3);
    }

    public static Map<String, String> getCodes(String string, String string2, String string3) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null || string2.trim().isEmpty()) {
            LOGGER.severe("The name of the dataflow cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string3 == null || string3.trim().isEmpty()) {
            LOGGER.severe("The name of the dimension cannot be null");
            throw new SdmxInvalidParameterException("The name of the dimension cannot be null");
        }
        DataFlowStructure dataFlowStructure = SdmxClientHandler.getDataFlowStructure(string, string2);
        Dimension dimension = dataFlowStructure.getDimension(string3);
        Codelist codelist = null;
        if (dimension != null) {
            codelist = dimension.getCodeList();
            if (codelist != null && !codelist.isEmpty()) {
                return codelist;
            }
            LOGGER.finer("Codelist for " + string + ", " + string2 + ", " + string3 + " not cached.");
            codelist = SdmxClientHandler.getClient(string).getCodes(dataFlowStructure.getDimension(string3).getCodeList());
            if (codelist == null) {
                throw new SdmxXmlContentException("Could not get codes for '" + string2 + "' in provider: '" + string + "'");
            }
        } else {
            throw new SdmxXmlContentException("The dimension: '" + string3 + "' does not exist in dataflow: '" + string2 + "'");
        }
        dimension.setCodeList(codelist);
        return codelist;
    }

    public static Dataflow getFlow(String string, String string2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null || string2.trim().isEmpty()) {
            LOGGER.severe("The name of the dataflow cannot be null");
            throw new SdmxInvalidParameterException("The name of the dataflow cannot be null");
        }
        Provider provider = SdmxClientHandler.getProvider(string);
        Dataflow dataflow = provider.getFlow(string2);
        if (dataflow == null) {
            LOGGER.fine("Dataflow " + string2 + " not cached. Calling Provider.");
            dataflow = SdmxClientHandler.getClient(string).getDataflow(string2, null, null);
            if (dataflow != null) {
                provider.setFlow(dataflow);
            } else {
                throw new SdmxXmlContentException("Could not get dataflow '" + string2 + "' in provider: '" + string + "'");
            }
        }
        return dataflow;
    }

    public static Map<String, String> getFlows(String string, String string2) throws SdmxException {
        Map<String, Dataflow> map = SdmxClientHandler.getFlowObjects(string, string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, Dataflow> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().getDescription());
        }
        return hashMap;
    }

    public static Map<String, Dataflow> getFlowObjects(String string, String string2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        Map<String, Dataflow> map = null;
        Provider provider = SdmxClientHandler.getProvider(string);
        map = provider.getFlows();
        if (map == null || map.size() == 0 || !provider.isFull()) {
            LOGGER.fine("Flows for " + string + " not cached. Calling Provider.");
            map = SdmxClientHandler.getClient(string).getDataflows();
            if (map != null && map.size() != 0) {
                provider.setFlows(map);
                provider.setFull(true);
            } else {
                throw new SdmxXmlContentException("Could not get dataflows from provider: '" + string + "'");
            }
        }
        return SdmxClientHandler.filterFlows(map, string2);
    }

    public static PortableDataSet<Double> getTimeSeriesTable(String string, String string2, String string3, String string4, boolean bl, String string5, boolean bl2) throws SdmxException, DataStructureException {
        return new PortableDataSet<Double>(SdmxClientHandler.getTimeSeries(string, string2, string3, string4, bl, string5, bl2));
    }

    public static PortableDataSet<Double> getTimeSeriesTable2(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl) throws SdmxException, DataStructureException {
        PortableDataSet<Double> portableDataSet = new PortableDataSet<Double>(SdmxClientHandler.getTimeSeries2(string, string2, string3, string4, string5, string6, string7, string8, string9, bl));
        portableDataSet.setDataflow(SdmxClientHandler.getFlow(string, string2).getFullIdentifier());
        return portableDataSet;
    }

    public static List<PortableTimeSeries<Double>> getTimeSeries(String string, String string2, String string3, String string4, boolean bl, String string5, boolean bl2) throws SdmxException {
        ArrayList<PortableTimeSeries<Double>> arrayList = new ArrayList<PortableTimeSeries<Double>>();
        for (String string6 : string2.trim().split("\\s*;\\s*")) {
            arrayList.addAll(SdmxClientHandler.getSingleTimeSeries(string, string6, string3, string4, bl, string5, bl2));
        }
        return arrayList;
    }

    public static List<PortableTimeSeries<Double>> getTimeSeries2(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null || string2.trim().isEmpty()) {
            LOGGER.severe("The dataflow must have valid values");
            throw new SdmxInvalidParameterException("The dataflow must have valid values");
        }
        Dataflow dataflow = SdmxClientHandler.getFlow(string, string2);
        DataFlowStructure dataFlowStructure = SdmxClientHandler.getDataFlowStructure(string, string2);
        List<PortableTimeSeries<Double>> list = SdmxClientHandler.getClient(string).getTimeSeries(dataflow, dataFlowStructure, string3, string4, string5, string6, string7, string8, string9, bl);
        if (list == null || list.size() == 0) {
            throw new SdmxXmlContentException("The query: key=" + string3 + " and filter=" + string4 + " did not match any time series on the provider for dataflow: " + string2);
        }
        return list;
    }

    private static List<PortableTimeSeries<Double>> getSingleTimeSeries(String string, String string2, String string3, String string4, boolean bl, String string5, boolean bl2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null || string2.trim().isEmpty()) {
            LOGGER.severe("The ts key must have valid values");
            throw new SdmxInvalidParameterException("The ts key must have valid values");
        }
        List<PortableTimeSeries<Double>> list = null;
        String[] stringArray = SdmxClientHandler.extractFlowAndResource(string2);
        String string6 = stringArray[0];
        string2 = stringArray[1];
        Dataflow dataflow = SdmxClientHandler.getFlow(string, string6);
        DataFlowStructure dataFlowStructure = SdmxClientHandler.getDataFlowStructure(string, string6);
        list = SdmxClientHandler.getClient(string).getTimeSeries(dataflow, dataFlowStructure, string2, string3, string4, bl, string5, bl2);
        if (list == null || list.size() == 0) {
            throw new SdmxXmlContentException("The query: key=" + string2 + " did not match any time series on the provider for dataflow: " + string6);
        }
        return list;
    }

    public static String getDataURL(String string, String string2, String string3, String string4, String string5, boolean bl, String string6, boolean bl2) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null || string2.trim().isEmpty()) {
            LOGGER.severe("The dataflow cannot be null");
            throw new SdmxInvalidParameterException("The dataflow cannot be null");
        }
        if (string3 == null || string3.trim().isEmpty()) {
            LOGGER.severe("The query cannot be null");
            throw new SdmxInvalidParameterException("The query cannot be null");
        }
        Dataflow dataflow = SdmxClientHandler.getFlow(string, string2);
        String string7 = SdmxClientHandler.getClient(string).buildDataURL(dataflow, string3, string4, string5, bl, string6, bl2);
        return string7;
    }

    public static String dumpTimeSeriesList(List<PortableTimeSeries<Double>> list) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        boolean bl = true;
        for (PortableTimeSeries<Double> portableTimeSeries : list) {
            if (!bl) {
                stringBuffer.append(";");
            }
            bl = false;
            stringBuffer.append(";").append(portableTimeSeries.getName());
            int n2 = portableTimeSeries.size();
            if (n2 > n) {
                n = n2;
            }
            if (!Configuration.isReverse()) continue;
            portableTimeSeries.reverse();
        }
        stringBuffer.append("\n");
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < list.size(); ++j) {
                if (i < list.get(j).size()) {
                    stringBuffer.append(((BaseObservation)list.get(j).get(i)).getTimeslot()).append(";");
                    stringBuffer.append(((BaseObservation)list.get(j).get(i)).getValue());
                } else {
                    stringBuffer.append(";");
                }
                if (j + 1 >= list.size()) continue;
                stringBuffer.append(";");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String dumpTimeSeries(String string, String string2, String string3, String string4) throws SdmxException, DataStructureException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        if (string2 == null || string2.trim().isEmpty()) {
            LOGGER.severe("The id cannot be null");
            throw new SdmxInvalidParameterException("The id cannot be null");
        }
        if (!SDMXClientFactory.getProviders().containsKey(string)) {
            throw new SdmxInvalidParameterException("The provider : " + string2 + " does not exist.");
        }
        String string5 = "";
        if (!Configuration.isTable()) {
            List<PortableTimeSeries<Double>> list = SdmxClientHandler.getTimeSeries(string, string2, string3, string4, false, null, false);
            string5 = SdmxClientHandler.dumpTimeSeriesList(list);
        } else {
            string5 = SdmxClientHandler.getTimeSeriesTable(string, string2, string3, string4, false, null, false).toString();
        }
        return string5;
    }

    private static Provider getProvider(String string) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        Provider provider = (Provider)SDMXClientFactory.getProviders().get(string);
        if (provider == null) {
            throw new SdmxUnknownProviderException(string);
        }
        return provider;
    }

    private static GenericSDMXClient getClient(String string, String string2, String string3) throws SdmxException {
        LOGGER.entering(sourceClass, "getClient");
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        GenericSDMXClient genericSDMXClient = clients.get(string);
        if (genericSDMXClient == null) {
            LOGGER.finer("Client for " + string + " does not exist. I will create it.");
            genericSDMXClient = SDMXClientFactory.createClient(string);
            if (genericSDMXClient.needsCredentials()) {
                SdmxClientHandler.handlePassword(genericSDMXClient, string2, string3);
            }
            clients.put(string, genericSDMXClient);
        }
        LOGGER.exiting(sourceClass, "getClient");
        return genericSDMXClient;
    }

    private static GenericSDMXClient getClient(String string) throws SdmxException {
        if (string == null || string.trim().isEmpty()) {
            LOGGER.severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException("The name of the provider cannot be null");
        }
        return SdmxClientHandler.getClient(string, null, null);
    }

    private static void handlePassword(GenericSDMXClient genericSDMXClient, String string, String string2) throws SdmxException {
        if (genericSDMXClient == null) {
            LOGGER.severe("The client cannot be null");
            throw new SdmxInvalidParameterException("The client cannot be null");
        }
        if (genericSDMXClient.needsCredentials()) {
            if (string == null || string2 == null) {
                JFrame jFrame = new JFrame("Authentication");
                jFrame.setDefaultCloseOperation(2);
                LoginDialog loginDialog = new LoginDialog((Frame)jFrame, genericSDMXClient.getName() + " Authentication");
                loginDialog.setVisible(true);
                genericSDMXClient.setCredentials(loginDialog.getUsername(), loginDialog.getPassword());
                jFrame.dispose();
            } else {
                genericSDMXClient.setCredentials(string, string2);
            }
        }
    }

    private static Map<String, Dataflow> filterFlows(Map<String, Dataflow> map, String string) {
        LOGGER.entering(sourceClass, "filterFlows");
        HashMap<String, Dataflow> hashMap = new HashMap<String, Dataflow>();
        if (map != null && map.size() > 0) {
            if (string != null && !string.trim().isEmpty()) {
                string = string.replaceAll("\\*", ".*").replaceAll("\\?", ".");
            }
            for (Map.Entry<String, Dataflow> entry : map.entrySet()) {
                String string2 = entry.getKey().split(",").length > 2 ? entry.getKey().split(",")[1] : entry.getKey();
                String string3 = entry.getValue().getDescription();
                if (string != null && !string.trim().isEmpty()) {
                    if (!string2.matches(string) && !string3.matches(string)) continue;
                    hashMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        LOGGER.exiting(sourceClass, "filterFlows");
        return hashMap;
    }

    private static String[] translateLegacyTSQuery(String string) {
        String[] stringArray = new String[2];
        String string2 = "[.]";
        String[] stringArray2 = string.split(string2, 2);
        if (stringArray2.length == 2) {
            stringArray[0] = stringArray2[0];
            String string3 = stringArray2[1];
            string3 = string3.replace("*", "");
            stringArray[1] = string3 = string3.replace('|', '+');
        } else {
            LOGGER.severe("Error in query string format: '" + string + "'. Could not get dataflow id.");
        }
        return stringArray;
    }

    public static String[] extractFlowAndResource(String string) throws SdmxException {
        String string2;
        String[] stringArray = (string = string.trim()).split(string2 = "[ /]", 2);
        if (stringArray.length != 2 && (stringArray = SdmxClientHandler.translateLegacyTSQuery(string)).length != 2) {
            throw new SdmxXmlContentException("Malformed time series key: " + string);
        }
        return stringArray;
    }
}

