/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.api;

import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.SDMXReference;
import it.bancaditalia.oss.sdmx.api.SdmxAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataFlowStructure
extends SDMXReference {
    private String name;
    private String timeDimension;
    private String primaryMeasure;
    private final Map<String, Dimension> dimensions = new HashMap<String, Dimension>();
    private final Map<String, SdmxAttribute> attributes = new HashMap<String, SdmxAttribute>();

    public DataFlowStructure(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public List<Dimension> getDimensions() {
        Dimension[] dimensionArray = new Dimension[this.dimensions.size()];
        Iterator<Dimension> iterator = this.dimensions.values().iterator();
        while (iterator.hasNext()) {
            Dimension dimension;
            dimensionArray[dimension.getPosition() - 1] = dimension = iterator.next();
        }
        return Arrays.asList(dimensionArray);
    }

    public List<SdmxAttribute> getAttributes() {
        return new ArrayList<SdmxAttribute>(this.attributes.values());
    }

    public void setDimension(Dimension dimension) {
        this.dimensions.put(dimension.getId(), dimension);
    }

    public Dimension getDimension(String string) {
        return this.dimensions.get(string);
    }

    public void setAttribute(SdmxAttribute sdmxAttribute) {
        this.attributes.put(sdmxAttribute.getId(), sdmxAttribute);
    }

    public SdmxAttribute getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void setTimeDimension(String string) {
        this.timeDimension = string;
    }

    public boolean isDimension(String string) {
        return this.dimensions.containsKey(string);
    }

    public int getDimensionPosition(String string) {
        return this.dimensions.get(string).getPosition();
    }

    public String getTimeDimension() {
        return this.timeDimension;
    }

    @Override
    public String toString() {
        return String.format("DSD [id=%s, name=%s, dimensions=\n%s, attributes=\n%s]", this.getFullIdentifier(), this.name, this.dimensions, this.attributes);
    }

    public String getMeasure() {
        return this.primaryMeasure;
    }

    public void setMeasure(String string) {
        this.primaryMeasure = string;
    }
}

