/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.helper.ProgressViewer;
import it.bancaditalia.oss.sdmx.helper.QueryContentFrame;
import it.bancaditalia.oss.sdmx.helper.QueryPanel;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

class GetQueryContentTask
extends SwingWorker<Void, Void> {
    private static Logger logger = Configuration.getSdmxLogger();
    private ProgressViewer progress = null;

    public GetQueryContentTask(ProgressViewer progressViewer) {
        this.progress = progressViewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        String string = QueryPanel.sdmxQuery.getText();
        try {
            if (string == null || string.isEmpty()) {
                throw new SdmxInvalidParameterException("The sdmx query is not valid yet: '" + string + "'");
            }
            List<PortableTimeSeries> list = SdmxClientHandler.getTimeSeriesNames(QueryPanel.selectedProvider, string);
            Dataflow dataflow = SdmxClientHandler.getFlow(QueryPanel.selectedProvider, QueryPanel.selectedDataflow);
            QueryContentFrame queryContentFrame = new QueryContentFrame(list);
            queryContentFrame.setTitle(list.size() + " results" + " - " + dataflow.getDescription());
            this.progress.setVisible(false);
            queryContentFrame.setVisible(true);
        }
        catch (SdmxException sdmxException) {
            logger.severe("Exception. Class: " + sdmxException.getClass().getName() + " .Message: " + sdmxException.getMessage());
            logger.log(Level.FINER, "", sdmxException);
        }
        finally {
            this.progress.setVisible(false);
        }
        return null;
    }
}

