/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.DSDIdentifier;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.client.custom.RestSdmx20Client;
import it.bancaditalia.oss.sdmx.parser.v20.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v21.RestQueryBuilder;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DotStat
extends RestSdmx20Client {
    protected static Logger logger = Configuration.getSdmxLogger();

    public DotStat(String string, URL uRL, boolean bl, String string2) throws MalformedURLException {
        super(string, uRL, bl, null, string2);
    }

    public DotStat(String string, URL uRL, boolean bl) throws MalformedURLException {
        super(string, uRL, bl, null, "compact_v2");
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        Dataflow dataflow;
        block11: {
            String string4 = null;
            InputStreamReader inputStreamReader = null;
            dataflow = null;
            string4 = this.buildFlowQuery(string, "all", "latest");
            inputStreamReader = this.runQuery(string4, null);
            if (inputStreamReader != null) {
                try {
                    List<DataFlowStructure> list = DataStructureParser.parse(inputStreamReader);
                    if (list.size() > 0) {
                        DataFlowStructure dataFlowStructure = list.get(0);
                        dataflow = new Dataflow();
                        dataflow.setAgency(dataFlowStructure.getAgency());
                        dataflow.setId(dataFlowStructure.getId());
                        dataflow.setVersion(dataFlowStructure.getVersion());
                        dataflow.setName(dataFlowStructure.getName());
                        DSDIdentifier dSDIdentifier = new DSDIdentifier();
                        dSDIdentifier.setAgency(dataFlowStructure.getAgency());
                        dSDIdentifier.setId(dataFlowStructure.getId());
                        dSDIdentifier.setVersion(dataFlowStructure.getVersion());
                        dataflow.setDsdIdentifier(dSDIdentifier);
                        break block11;
                    }
                    throw new SdmxException("The query returned zero dataflows");
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.name);
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
                finally {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
            }
            throw new SdmxException("The query returned a null stream");
        }
        return dataflow;
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        HashMap<String, Dataflow> hashMap;
        block12: {
            String string = null;
            InputStreamReader inputStreamReader = null;
            hashMap = new HashMap<String, Dataflow>();
            string = this.buildFlowQuery("ALL", "all", "latest");
            inputStreamReader = this.runQuery(string, null);
            if (inputStreamReader != null) {
                try {
                    List<DataFlowStructure> list = DataStructureParser.parse(inputStreamReader);
                    if (list.size() > 0) {
                        hashMap = new HashMap();
                        for (DataFlowStructure dataFlowStructure : list) {
                            Dataflow dataflow = new Dataflow();
                            dataflow.setAgency(dataFlowStructure.getAgency());
                            dataflow.setId(dataFlowStructure.getId());
                            dataflow.setVersion(dataFlowStructure.getVersion());
                            dataflow.setName(dataFlowStructure.getName());
                            DSDIdentifier dSDIdentifier = new DSDIdentifier();
                            dSDIdentifier.setAgency(dataFlowStructure.getAgency());
                            dSDIdentifier.setId(dataFlowStructure.getId());
                            dSDIdentifier.setVersion(dataFlowStructure.getVersion());
                            dataflow.setDsdIdentifier(dSDIdentifier);
                            hashMap.put(dataFlowStructure.getId(), dataflow);
                        }
                        break block12;
                    }
                    throw new SdmxException("The query returned zero dataflows");
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.name);
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
                finally {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
            }
            throw new SdmxException("The query returned a null stream");
        }
        return hashMap;
    }

    @Override
    protected String buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        return this.buildDSDQuery(string, string2, string3);
    }

    @Override
    protected String buildDSDQuery(String string, String string2, String string3) {
        if (this.endpoint != null && string != null && !string.isEmpty()) {
            String string4 = this.endpoint + "/GetDataStructure/" + string;
            return string4;
        }
        throw new RuntimeException("Invalid query parameters: dsd=" + string + " endpoint=" + this.endpoint);
    }

    @Override
    protected String buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        if (this.endpoint != null && dataflow != null && string != null && !string.isEmpty()) {
            String string5 = this.endpoint + "/GetData/" + dataflow.getId() + "/";
            string5 = string5 + string;
            string5 = string5 + RestQueryBuilder.addParams(string2, string3, bl, string4, bl2, this.format);
            return string5;
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.endpoint);
    }
}

