/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.client;

import it.bankitalia.reri.sia.sdmx.api.GenericSDMXClient;
import it.bankitalia.reri.sia.sdmx.client.HttpsSdmxClient;
import it.bankitalia.reri.sia.sdmx.client.Provider;
import it.bankitalia.reri.sia.sdmx.client.RestSdmxClient;
import it.bankitalia.reri.sia.util.Configuration;
import it.bankitalia.reri.sia.util.SdmxException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SDMXClientFactory {
    private static final String ECB_PROVIDER = "http://sdw-wsrest.ecb.europa.eu/service";
    private static final String BIS_PROVIDER = "https://dbsonline.bis.org/sdmx21/rest";
    private static final String EUROSTAT_PROVIDER = "http://ec.europa.eu/eurostat/SDMX/diss-web/rest";
    private static final String sourceClass;
    protected static Logger logger;
    private static Map<String, Provider> providers;

    private static void initBuiltInProviders() {
        providers = new HashMap<String, Provider>();
        try {
            SDMXClientFactory.addProvider("ECB", "ECB", new URL(ECB_PROVIDER), false);
            SDMXClientFactory.addProvider("BIS", "BIS", new URL(BIS_PROVIDER), true);
            SDMXClientFactory.addProvider("EUROSTAT", "ESTAT", new URL(EUROSTAT_PROVIDER), false);
        }
        catch (MalformedURLException malformedURLException) {
            logger.severe("Exception. Class: " + malformedURLException.getClass().getName() + " .Message: " + malformedURLException.getMessage());
            logger.log(Level.FINER, "", malformedURLException);
        }
        SDMXClientFactory.addProvider("OECD", "OECD", null, false);
        SDMXClientFactory.addProvider("ILO", "ILO", null, false);
        ServiceLoader<GenericSDMXClient> serviceLoader = ServiceLoader.load(GenericSDMXClient.class);
        for (GenericSDMXClient genericSDMXClient : serviceLoader) {
            SDMXClientFactory.addProvider(genericSDMXClient.getClass().getSimpleName(), genericSDMXClient.getAgency(), null, genericSDMXClient.needsCredentials());
        }
    }

    public static void addProvider(String string, String string2, URL uRL, boolean bl) {
        Provider provider = new Provider(string, string2, uRL, bl);
        providers.put(string, provider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GenericSDMXClient createClient(String string) throws SdmxException {
        logger.entering(sourceClass, "createClient");
        logger.fine("Create an SDMX client for '" + string + "'");
        GenericSDMXClient genericSDMXClient = null;
        Provider provider = providers.get(string);
        String string2 = "The provider '" + string + "' is not available in this configuration.";
        if (provider != null && provider.getEndpoint() != null) {
            if (provider.getEndpoint().getProtocol().equals("http")) {
                genericSDMXClient = new RestSdmxClient(provider.getName(), provider.getEndpoint(), provider.getAgency(), provider.isNeedsCredentials(), false);
            } else {
                if (!provider.getEndpoint().getProtocol().equals("https")) {
                    logger.severe("The protocol '" + provider.getEndpoint().getProtocol() + "' is not supported.");
                    throw new SdmxException(string2);
                }
                try {
                    genericSDMXClient = new HttpsSdmxClient(provider.getName(), provider.getEndpoint(), provider.getAgency(), provider.isNeedsCredentials(), false);
                }
                catch (KeyManagementException keyManagementException) {
                    logger.severe("Exception. Class: " + keyManagementException.getClass().getName() + " .Message: " + keyManagementException.getMessage());
                    logger.log(Level.FINER, "", keyManagementException);
                    throw new SdmxException(string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    logger.severe("Exception. Class: " + noSuchAlgorithmException.getClass().getName() + " .Message: " + noSuchAlgorithmException.getMessage());
                    logger.log(Level.FINER, "", noSuchAlgorithmException);
                    throw new SdmxException(string2);
                }
            }
        } else {
            try {
                Class<?> clazz = Class.forName("it.bankitalia.reri.sia.sdmx.client.custom." + string);
                genericSDMXClient = (GenericSDMXClient)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.severe("The provider '" + string + "' is not available in this configuration.");
                throw new SdmxException(string2);
            }
            catch (Exception exception) {
                logger.severe("Exception caught. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                logger.log(Level.FINER, "Exception caught. ", exception);
                throw new SdmxException(string2);
            }
        }
        logger.exiting(sourceClass, "createClient");
        return genericSDMXClient;
    }

    public static Map<String, Provider> getProviders() {
        return providers;
    }

    static {
        Configuration.init();
        SDMXClientFactory.initBuiltInProviders();
        sourceClass = SDMXClientFactory.class.getSimpleName();
        logger = Configuration.getSdmxLogger();
    }
}

