/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.sdmx.client;

import it.bankitalia.reri.sia.sdmx.api.DSDIdentifier;
import it.bankitalia.reri.sia.sdmx.api.DataFlowStructure;
import it.bankitalia.reri.sia.sdmx.api.Dataflow;
import it.bankitalia.reri.sia.sdmx.api.GenericSDMXClient;
import it.bankitalia.reri.sia.sdmx.api.PortableTimeSeries;
import it.bankitalia.reri.sia.sdmx.parser.v21.CodelistParser;
import it.bankitalia.reri.sia.sdmx.parser.v21.CompactDataParser;
import it.bankitalia.reri.sia.sdmx.parser.v21.DataStructureParser;
import it.bankitalia.reri.sia.sdmx.parser.v21.DataflowParser;
import it.bankitalia.reri.sia.sdmx.parser.v21.RestQueryBuilder;
import it.bankitalia.reri.sia.util.Configuration;
import it.bankitalia.reri.sia.util.SdmxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

public class RestSdmxClient
implements GenericSDMXClient {
    protected boolean dotStat = false;
    protected URL wsEndpoint = null;
    protected String agencyID = null;
    protected String name = null;
    protected boolean needsCredentials = false;
    protected boolean containsCredentials = false;
    protected String user = null;
    protected String pw = null;
    private static final String sourceClass = RestSdmxClient.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();

    public RestSdmxClient(String string, URL uRL, String string2, boolean bl, boolean bl2) {
        this.wsEndpoint = uRL;
        this.agencyID = string2;
        this.name = string;
        this.needsCredentials = bl;
        this.dotStat = bl2;
    }

    protected String runQuery(String string, String string2) throws SdmxException {
        Object object;
        logger.entering(sourceClass, "runQuery");
        logger.info("Contacting web service with query: " + string);
        StringBuilder stringBuilder = new StringBuilder(1000);
        try {
            object = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)object).openConnection();
            httpURLConnection.setRequestMethod("GET");
            this.handleHttpHeaders(httpURLConnection, string2);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                String string3;
                logger.fine("Connection opened. Code: " + n);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string3);
                }
            } else {
                String string4 = "Connection failed. HTTP error code : " + httpURLConnection.getResponseCode() + " Message: " + httpURLConnection.getResponseMessage();
                logger.severe(string4);
                throw new SdmxException(string4);
            }
            httpURLConnection.disconnect();
            logger.fine("Connection closed.");
        }
        catch (IOException iOException) {
            logger.severe("Exception caught calling provider " + this.getAgency());
            logger.log(Level.FINER, "Exception: ", iOException);
            throw new SdmxException("Exception. Class: " + iOException.getClass().getName() + " .Message: " + iOException.getMessage());
        }
        logger.exiting(sourceClass, "runQuery");
        object = stringBuilder.toString();
        return object;
    }

    @Override
    public List<PortableTimeSeries> getTimeSeries(String string, DataFlowStructure dataFlowStructure, String string2, String string3, String string4) throws SdmxException {
        String string5 = null;
        String string6 = null;
        List<PortableTimeSeries> list = null;
        string5 = this.buildDataQuery(this.wsEndpoint, string, string2, string3, string4);
        string6 = this.runQuery(string5, "application/vnd.sdmx.structurespecificdata+xml;version=2.1");
        if (string6 != null && !string6.isEmpty()) {
            logger.finest(string6);
            try {
                list = CompactDataParser.parse(string6, dataFlowStructure, string);
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.getAgency());
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
        } else {
            throw new SdmxException("The query returned an empty result");
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DataFlowStructure getDataFlowStructure(DSDIdentifier dSDIdentifier) throws SdmxException {
        String string = null;
        String string2 = null;
        DataFlowStructure dataFlowStructure = null;
        if (dSDIdentifier == null) throw new SdmxException("Null dsd in input");
        string = this.buildStructureQuery(this.wsEndpoint, dSDIdentifier.getAgency(), dSDIdentifier.getId(), dSDIdentifier.getVersion());
        string2 = this.runQuery(string, null);
        if (string2 == null) throw new SdmxException("The query returned an empty result");
        if (string2.isEmpty()) throw new SdmxException("The query returned an empty result");
        logger.finest(string2);
        try {
            return DataStructureParser.parse(string2).get(0);
        }
        catch (Exception exception) {
            logger.severe("Exception caught parsing results from call to provider " + this.getAgency());
            logger.log(Level.FINER, "Exception: ", exception);
            throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
        }
    }

    @Override
    public DSDIdentifier getDSDIdentifier(String string, String string2) throws SdmxException {
        String string3 = null;
        String string4 = null;
        DSDIdentifier dSDIdentifier = null;
        string3 = RestQueryBuilder.getDataflowQuery(this.wsEndpoint, string, this.agencyID, string2);
        string4 = this.runQuery(string3, null);
        if (string4 != null && !string4.isEmpty()) {
            logger.finest(string4);
            try {
                List<Dataflow> list = DataflowParser.parse(string4);
                if (list.size() != 1) {
                    throw new SdmxException("The query returned zero dataflows");
                }
                Dataflow dataflow = list.get(0);
                dSDIdentifier = new DSDIdentifier(dataflow.getDsd(), dataflow.getDsdAgency(), dataflow.getDsdVersion());
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.getAgency());
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
        } else {
            throw new SdmxException("The query returned an empty result");
        }
        return dSDIdentifier;
    }

    @Override
    public Map<String, String> getDataflows() throws SdmxException {
        HashMap<String, String> hashMap;
        block5: {
            String string = null;
            String string2 = null;
            hashMap = null;
            string = this.buildDFQuery(this.wsEndpoint, "all", this.agencyID, "latest");
            string2 = this.runQuery(string, null);
            if (string2 != null && !string2.isEmpty()) {
                logger.finest(string2);
                try {
                    List<Dataflow> list = DataflowParser.parse(string2);
                    if (list.size() > 0) {
                        hashMap = new HashMap<String, String>();
                        for (Dataflow dataflow : list) {
                            hashMap.put(dataflow.getId(), dataflow.getName());
                        }
                        break block5;
                    }
                    throw new SdmxException("The query returned zero dataflows");
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.getAgency());
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
            }
            throw new SdmxException("The query returned an empty result");
        }
        return hashMap;
    }

    @Override
    public Map<String, String> getCodes(String string, String string2) throws SdmxException {
        String string3 = null;
        String string4 = null;
        Map<String, String> map = null;
        string3 = this.buildCodelistQuery(this.wsEndpoint, string2);
        string4 = this.runQuery(string3, null);
        if (string4 != null && !string4.isEmpty()) {
            logger.finest(string4);
            try {
                map = CodelistParser.parse(string4);
            }
            catch (Exception exception) {
                logger.severe("Exception caught parsing results from call to provider " + this.getAgency());
                logger.log(Level.FINER, "Exception: ", exception);
                throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            }
        } else {
            throw new SdmxException("The query returned an empty result");
        }
        return map;
    }

    @Override
    public String getAgency() {
        return this.agencyID;
    }

    @Override
    public boolean needsCredentials() {
        return this.needsCredentials;
    }

    @Override
    public void setCredentials(String string, String string2) {
        this.user = string;
        this.pw = string2;
        this.needsCredentials = false;
        this.containsCredentials = true;
    }

    protected void handleHttpHeaders(HttpURLConnection httpURLConnection, String string) {
        if (this.containsCredentials) {
            logger.fine("Setting http authorization");
            String string2 = DatatypeConverter.printBase64Binary((byte[])(this.user + ":" + this.pw).getBytes());
            httpURLConnection.setRequestProperty("Authorization", "Basic " + string2);
        }
        if (string != null) {
            httpURLConnection.setRequestProperty("Accept", string);
        }
    }

    protected String buildDataQuery(URL uRL, String string, String string2, String string3, String string4) {
        if (uRL != null && string != null && !string.isEmpty() && string2 != null && !string2.isEmpty()) {
            String string5 = RestQueryBuilder.getDataQuery(uRL, string, string2, string3, string4);
            return string5;
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + string + " resource=" + string2 + " endpoint=" + uRL);
    }

    protected String buildStructureQuery(URL uRL, String string, String string2, String string3) {
        if (uRL != null && string != null && !string.isEmpty() && string2 != null && !string2.isEmpty()) {
            String string4 = RestQueryBuilder.getStructureQuery(uRL, string, string2, string3);
            return string4;
        }
        throw new RuntimeException("Invalid query parameters: agency=" + string + " dsd=" + string2 + " endpoint=" + uRL);
    }

    protected String buildDFQuery(URL uRL, String string, String string2, String string3) throws SdmxException {
        String string4 = RestQueryBuilder.getDataflowQuery(uRL, string, string2, string3);
        return string4;
    }

    protected String buildCodelistQuery(URL uRL, String string) throws SdmxException {
        String string2 = RestQueryBuilder.getCodelistQuery(uRL, string);
        return string2;
    }
}

