/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.implementation.RegArimaProcessingFactory;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.RegressionTestSpec;
import ec.tstoolkit.modelling.arima.AICcComparator;
import ec.tstoolkit.modelling.arima.IModelEstimator;
import ec.tstoolkit.modelling.arima.IOutliersDetectionModule;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.IRegArimaSpecification;
import ec.tstoolkit.modelling.arima.UnitSeriesScaling;
import ec.tstoolkit.modelling.arima.x13.ArimaSpec;
import ec.tstoolkit.modelling.arima.x13.AutoModel;
import ec.tstoolkit.modelling.arima.x13.AutoModelSpec;
import ec.tstoolkit.modelling.arima.x13.BasicSpec;
import ec.tstoolkit.modelling.arima.x13.CalendarEffectsDetection;
import ec.tstoolkit.modelling.arima.x13.EasterDetection;
import ec.tstoolkit.modelling.arima.x13.EstimateSpec;
import ec.tstoolkit.modelling.arima.x13.FinalEstimator;
import ec.tstoolkit.modelling.arima.x13.LogLevelTest;
import ec.tstoolkit.modelling.arima.x13.MovingHolidaySpec;
import ec.tstoolkit.modelling.arima.x13.OutlierSpec;
import ec.tstoolkit.modelling.arima.x13.OutliersDetector;
import ec.tstoolkit.modelling.arima.x13.RegressionSpec;
import ec.tstoolkit.modelling.arima.x13.SingleOutlierSpec;
import ec.tstoolkit.modelling.arima.x13.TradingDaysSpec;
import ec.tstoolkit.modelling.arima.x13.TransformSpec;
import ec.tstoolkit.modelling.arima.x13.X13Estimator;
import ec.tstoolkit.modelling.arima.x13.X13ModelBuilder;
import ec.tstoolkit.modelling.arima.x13.X13Preprocessor;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.AdditiveOutlierFactory;
import ec.tstoolkit.timeseries.regression.LevelShiftFactory;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.OutliersFactory;
import ec.tstoolkit.timeseries.regression.SeasonalOutlierFactory;
import ec.tstoolkit.timeseries.regression.TransitoryChangeFactory;
import ec.tstoolkit.timeseries.simplets.ConstInterpolator;
import java.util.Map;
import java.util.Objects;

public class RegArimaSpecification
implements IRegArimaSpecification,
Cloneable {
    public static final RegArimaSpecification RGDISABLED;
    public static final RegArimaSpecification RG0;
    public static final RegArimaSpecification RG1;
    public static final RegArimaSpecification RG2;
    public static final RegArimaSpecification RG3;
    public static final RegArimaSpecification RG4;
    public static final RegArimaSpecification RG5;
    public static final String BASIC = "basic";
    public static final String TRANSFORM = "transform";
    public static final String AUTOMDL = "automdl";
    public static final String ARIMA = "arima";
    public static final String REGRESSION = "regression";
    public static final String OUTLIER = "outlier";
    public static final String ESTIMATE = "esimate";
    private static final String SMETHOD = "RG";
    static final LevelShiftFactory LFAC;
    static final TransitoryChangeFactory TFAC;
    static final AdditiveOutlierFactory AFAC;
    static final SeasonalOutlierFactory SFAC;
    private BasicSpec basic_ = new BasicSpec();
    private TransformSpec transform_ = new TransformSpec();
    private RegressionSpec regression_;
    private OutlierSpec outliers_;
    private AutoModelSpec automdl_;
    private ArimaSpec arima_;
    private EstimateSpec estimate_ = new EstimateSpec();

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        EstimateSpec.fillDictionary(InformationSet.item(prefix, ESTIMATE), dic);
        TransformSpec.fillDictionary(InformationSet.item(prefix, TRANSFORM), dic);
        AutoModelSpec.fillDictionary(InformationSet.item(prefix, AUTOMDL), dic);
        ArimaSpec.fillDictionary(InformationSet.item(prefix, ARIMA), dic);
        OutlierSpec.fillDictionary(InformationSet.item(prefix, OUTLIER), dic);
        RegressionSpec.fillDictionary(InformationSet.item(prefix, REGRESSION), dic);
    }

    public static final RegArimaSpecification[] allSpecifications() {
        return new RegArimaSpecification[]{RG0, RG1, RG2, RG3, RG4, RG5};
    }

    public RegArimaSpecification() {
        this.automdl_ = new AutoModelSpec();
        this.outliers_ = new OutlierSpec();
        this.arima_ = new ArimaSpec();
        this.regression_ = new RegressionSpec();
    }

    public BasicSpec getBasic() {
        return this.basic_;
    }

    public OutlierSpec getOutliers() {
        return this.outliers_;
    }

    public OutliersFactory getOutliersFactory() {
        OutliersFactory fac = new OutliersFactory(false);
        fac.register(AFAC);
        fac.register(LFAC);
        fac.register(SFAC);
        if (this.outliers_.getMonthlyTCRate() == 0.7) {
            fac.register(TFAC);
        } else {
            TransitoryChangeFactory t = new TransitoryChangeFactory();
            t.setCoefficient(this.outliers_.getMonthlyTCRate());
            t.setMonthlyCoefficient(true);
            fac.register(t);
        }
        return fac;
    }

    public void setOutliers(OutlierSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(OUTLIER);
        }
        this.outliers_ = value;
    }

    public AutoModelSpec getAutoModel() {
        return this.automdl_;
    }

    public void setAutoModel(AutoModelSpec automdl) {
        if (automdl == null) {
            throw new IllegalArgumentException(AUTOMDL);
        }
        this.automdl_ = automdl;
        this.automdl_.setEnabled(true);
    }

    public ArimaSpec getArima() {
        return this.arima_;
    }

    public void setArima(ArimaSpec arima) {
        if (arima == null) {
            throw new IllegalArgumentException(ARIMA);
        }
        this.arima_ = arima;
        this.automdl_.setEnabled(false);
    }

    public TransformSpec getTransform() {
        return this.transform_;
    }

    public void setTransform(TransformSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(TRANSFORM);
        }
        this.transform_ = value;
    }

    public RegressionSpec getRegression() {
        return this.regression_;
    }

    public void setRegression(RegressionSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(REGRESSION);
        }
        this.regression_ = value;
    }

    public EstimateSpec getEstimate() {
        return this.estimate_;
    }

    public void setEstimate(EstimateSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(ESTIMATE);
        }
        this.estimate_ = value;
    }

    public boolean isUsingAutoModel() {
        return this.automdl_.isEnabled();
    }

    public void setUsingAutoModel(boolean enableAutoModel) {
        this.automdl_.setEnabled(enableAutoModel);
    }

    private IPreprocessingModule makeTd(RegressionSpec m_regression) {
        TradingDaysSpec td;
        if (m_regression != null && (td = m_regression.getTradingDays()).isUsed() && td.getTest() != RegressionTestSpec.None) {
            CalendarEffectsDetection cl = new CalendarEffectsDetection(new AICcComparator(m_regression.getAICCDiff()));
            cl.setEpsilon(this.estimate_.getTol());
            return cl;
        }
        return null;
    }

    private IPreprocessingModule makeEaster(RegressionSpec m_regression) {
        MovingHolidaySpec espec;
        if (m_regression != null && (espec = m_regression.getEaster()) != null && espec.getTest() != RegressionTestSpec.None) {
            EasterDetection cl = new EasterDetection(new AICcComparator(m_regression.getAICCDiff()));
            if (espec.getTest() != RegressionTestSpec.Add) {
                cl.setDuration(espec.getW());
            }
            cl.setEpsilon(this.estimate_.getTol());
            return cl;
        }
        return null;
    }

    public static IPreprocessor defaultPreprocessor(Default option) {
        switch (option.ordinal()) {
            case 0: {
                return RGDISABLED.build();
            }
            case 1: {
                return RG0.build();
            }
            case 2: {
                return RG1.build();
            }
            case 3: {
                return RG2.build();
            }
            case 4: {
                return RG3.build();
            }
            case 5: {
                return RG4.build();
            }
            case 6: {
                return RG5.build();
            }
        }
        return null;
    }

    @Override
    public RegArimaSpecification clone() {
        try {
            RegArimaSpecification spec = (RegArimaSpecification)super.clone();
            spec.basic_ = this.basic_.clone();
            spec.transform_ = this.transform_.clone();
            spec.arima_ = this.arima_.clone();
            spec.automdl_ = this.automdl_.clone();
            spec.regression_ = this.regression_.clone();
            spec.outliers_ = this.outliers_.clone();
            spec.estimate_ = this.estimate_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    private IPreprocessingModule makeLogLevel(TransformSpec transform_) {
        if (transform_.getFunction() != DefaultTransformationType.Auto) {
            return null;
        }
        LogLevelTest ll = new LogLevelTest(transform_.getAICDiff());
        ll.setEpsilon(this.estimate_.getTol());
        return ll;
    }

    private IOutliersDetectionModule makeOutliers(OutlierSpec o) {
        if (!o.isUsed()) {
            return null;
        }
        SingleOutlierSpec[] types = o.getTypes();
        OutliersDetector detector = new OutliersDetector();
        detector.setEpsilon(this.estimate_.getTol());
        detector.setSpan(o.getSpan());
        block6: for (int i = 0; i < types.length; ++i) {
            switch (types[i].getType()) {
                case AO: {
                    detector.addOutlierFactory(AFAC);
                    continue block6;
                }
                case LS: {
                    detector.addOutlierFactory(LFAC);
                    continue block6;
                }
                case SO: {
                    detector.addOutlierFactory(SFAC);
                    continue block6;
                }
                case TC: {
                    if (this.outliers_.getMonthlyTCRate() == 0.7) {
                        detector.addOutlierFactory(TFAC);
                        continue block6;
                    }
                    TransitoryChangeFactory t = new TransitoryChangeFactory();
                    t.setCoefficient(this.outliers_.getMonthlyTCRate());
                    t.setMonthlyCoefficient(true);
                    detector.addOutlierFactory(t);
                }
            }
        }
        if (this.automdl_ != null) {
            detector.setPc(this.automdl_.getPercentReductionCV());
        }
        detector.setCriticalValue(o.getDefaultCriticalValue());
        return detector;
    }

    private IModelEstimator makeFinalEstimator(EstimateSpec estimate_) {
        FinalEstimator estimator = new FinalEstimator();
        estimator.setEpsilon(estimate_.getTol());
        return estimator;
    }

    private void makeAutoModelling(X13Preprocessor x13, AutoModelSpec automdl) {
        if (automdl.isEnabled()) {
            AutoModel ami = new AutoModel();
            ami.setEpsilon(this.estimate_.getTol());
            ami.setBalanced(automdl.isBalanced());
            ami.setMixed(automdl.isMixed());
            x13.autoModelling = ami;
            x13.setCheckMu(true);
            x13.setLjungBoxLimit(automdl.getLjungBoxLimit());
            x13.setMixed(automdl.isMixed());
        } else {
            x13.setCheckMu(false);
        }
    }

    public IPreprocessor build() {
        return this.build(null);
    }

    public IPreprocessor build(ProcessingContext context) {
        X13Preprocessor x13 = new X13Preprocessor();
        x13.estimateSpan = this.estimate_.getSpan();
        x13.builder = new X13ModelBuilder(this, context);
        x13.scaling = new UnitSeriesScaling();
        x13.missing = new ConstInterpolator();
        x13.loglevelTest = this.makeLogLevel(this.transform_);
        x13.outliers = this.makeOutliers(this.outliers_);
        this.makeAutoModelling(x13, this.automdl_);
        x13.tdTest = this.makeTd(this.regression_);
        x13.easterTest = this.makeEaster(this.regression_);
        x13.estimator = new X13Estimator(this.estimate_.getTol());
        x13.finalizer = this.makeFinalEstimator(this.estimate_);
        return x13;
    }

    public static boolean isSystem(RegArimaSpecification spec) {
        return spec == RGDISABLED || spec == RG0 || spec == RG1 || spec == RG2 || spec == RG3 || spec == RG4 || spec == RG5;
    }

    public static RegArimaSpecification matchSystem(RegArimaSpecification spec) {
        if (spec == RGDISABLED || spec == RG0 || spec == RG1 || spec == RG2 || spec == RG3 || spec == RG4 || spec == RG5) {
            return spec;
        }
        if (spec.equals(RGDISABLED)) {
            return RGDISABLED;
        }
        if (spec.equals(RG0)) {
            return RG0;
        }
        if (spec.equals(RG1)) {
            return RG1;
        }
        if (spec.equals(RG2)) {
            return RG2;
        }
        if (spec.equals(RG3)) {
            return RG3;
        }
        if (spec.equals(RG4)) {
            return RG4;
        }
        if (spec.equals(RG5)) {
            return RG5;
        }
        return null;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RegArimaSpecification && this.equals((RegArimaSpecification)obj);
    }

    private boolean equals(RegArimaSpecification spec) {
        if (this.isUsingAutoModel() != spec.isUsingAutoModel()) {
            return false;
        }
        if (!this.isUsingAutoModel() && !Objects.equals(spec.arima_, this.arima_)) {
            return false;
        }
        if (this.isUsingAutoModel() && !Objects.equals(spec.automdl_, this.automdl_)) {
            return false;
        }
        return Objects.equals(spec.basic_, this.basic_) && Objects.equals(spec.transform_, this.transform_) && Objects.equals(spec.regression_, this.regression_) && Objects.equals(spec.outliers_, this.outliers_) && Objects.equals(spec.estimate_, this.estimate_);
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + this.basic_.hashCode();
        hash = 23 * hash + this.transform_.hashCode();
        hash = 23 * hash + this.regression_.hashCode();
        hash = 23 * hash + this.outliers_.hashCode();
        hash = this.isUsingAutoModel() ? 23 * hash + this.automdl_.hashCode() : 23 * hash + this.arima_.hashCode();
        hash = 23 * hash + this.estimate_.hashCode();
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet reginfo;
        InformationSet estimateinfo;
        InformationSet outlierinfo;
        InformationSet amiinfo;
        InformationSet arimainfo;
        InformationSet specInfo = new InformationSet();
        specInfo.add("algorithm", RegArimaProcessingFactory.DESCRIPTOR);
        InformationSet binfo = this.basic_.write(verbose);
        if (binfo != null) {
            specInfo.add(BASIC, binfo);
        }
        if (!this.basic_.isPreprocessing()) {
            return specInfo;
        }
        InformationSet tinfo = this.transform_.write(verbose);
        if (tinfo != null) {
            specInfo.add(TRANSFORM, tinfo);
        }
        if ((arimainfo = this.arima_.write(verbose)) != null) {
            specInfo.add(ARIMA, arimainfo);
        }
        if ((amiinfo = this.automdl_.write(verbose)) != null) {
            specInfo.add(AUTOMDL, amiinfo);
        }
        if ((outlierinfo = this.outliers_.write(verbose)) != null) {
            specInfo.add(OUTLIER, outlierinfo);
        }
        if ((estimateinfo = this.estimate_.write(verbose)) != null) {
            specInfo.add(ESTIMATE, estimateinfo);
        }
        if ((reginfo = this.regression_.write(verbose)) != null) {
            specInfo.add(REGRESSION, reginfo);
        }
        return specInfo;
    }

    @Override
    public boolean read(InformationSet info) {
        boolean tok;
        boolean tok2;
        boolean tok3;
        boolean tok4;
        boolean tok5;
        boolean tok6;
        boolean tok7;
        InformationSet binfo = info.getSubSet(BASIC);
        if (binfo != null && !(tok7 = this.basic_.read(binfo))) {
            return false;
        }
        if (!this.basic_.isPreprocessing()) {
            return true;
        }
        InformationSet tinfo = info.getSubSet(TRANSFORM);
        if (tinfo != null && !(tok6 = this.transform_.read(tinfo))) {
            return false;
        }
        InformationSet oinfo = info.getSubSet(OUTLIER);
        if (oinfo != null && !(tok5 = this.outliers_.read(oinfo))) {
            return false;
        }
        InformationSet ainfo = info.getSubSet(ARIMA);
        if (ainfo != null && !(tok4 = this.arima_.read(ainfo))) {
            return false;
        }
        InformationSet amiinfo = info.getSubSet(AUTOMDL);
        if (amiinfo != null && !(tok3 = this.automdl_.read(amiinfo))) {
            return false;
        }
        InformationSet einfo = info.getSubSet(ESTIMATE);
        if (einfo != null && !(tok2 = this.estimate_.read(einfo))) {
            return false;
        }
        InformationSet rinfo = info.getSubSet(REGRESSION);
        return rinfo == null || (tok = this.regression_.read(rinfo));
    }

    public String toString() {
        if (this == RG0) {
            return "RG0";
        }
        if (this == RG1) {
            return "RG1";
        }
        if (this == RG2) {
            return "RG2c";
        }
        if (this == RG3) {
            return "RG3";
        }
        if (this == RG4) {
            return "RG4c";
        }
        if (this == RG5) {
            return "RG5c";
        }
        if (this.equals(RG0)) {
            return "RG0";
        }
        if (this.equals(RG1)) {
            return "RG1";
        }
        if (this.equals(RG2)) {
            return "RG2c";
        }
        if (this.equals(RG3)) {
            return "RG3";
        }
        if (this.equals(RG4)) {
            return "RG4c";
        }
        if (this.equals(RG5)) {
            return "RG5c";
        }
        return SMETHOD;
    }

    public String toLongString() {
        String s = this.toString();
        if (SMETHOD.equals(s)) {
            return s;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("RG[").append(s).append(']');
        return builder.toString();
    }

    public static RegArimaSpecification fromString(String name) {
        switch (name) {
            case "RG0": {
                return RG0;
            }
            case "RG1": {
                return RG1;
            }
            case "RG2c": {
                return RG2;
            }
            case "RG3": {
                return RG3;
            }
            case "RG4c": {
                return RG4;
            }
            case "RG5c": {
                return RG5;
            }
        }
        return new RegArimaSpecification();
    }

    static {
        LFAC = new LevelShiftFactory();
        LFAC.setZeroEnded(true);
        TFAC = new TransitoryChangeFactory();
        TFAC.setMonthlyCoefficient(true);
        AFAC = new AdditiveOutlierFactory();
        SFAC = new SeasonalOutlierFactory();
        SFAC.setZeroEnded(true);
        RGDISABLED = new RegArimaSpecification();
        RG0 = new RegArimaSpecification();
        RG1 = new RegArimaSpecification();
        RG2 = new RegArimaSpecification();
        RG3 = new RegArimaSpecification();
        RG4 = new RegArimaSpecification();
        RG5 = new RegArimaSpecification();
        RGDISABLED.getBasic().setPreprocessing(false);
        TransformSpec tr = new TransformSpec();
        tr.setFunction(DefaultTransformationType.Auto);
        MovingHolidaySpec easter = MovingHolidaySpec.easterSpec(true);
        TradingDaysSpec wd = new TradingDaysSpec();
        wd.setTradingDaysType(TradingDaysType.WorkingDays);
        wd.setLengthOfPeriod(LengthOfPeriodType.LeapYear);
        wd.setTest(RegressionTestSpec.Remove);
        TradingDaysSpec td = new TradingDaysSpec();
        td.setTradingDaysType(TradingDaysType.TradingDays);
        td.setLengthOfPeriod(LengthOfPeriodType.LeapYear);
        td.setTest(RegressionTestSpec.Remove);
        RegressionSpec rwd = new RegressionSpec();
        rwd.add(easter);
        rwd.setTradingDays(wd);
        RegressionSpec rtd = new RegressionSpec();
        rtd.add(easter);
        rtd.setTradingDays(td);
        OutlierSpec o = new OutlierSpec();
        o.add(OutlierType.AO);
        o.add(OutlierType.TC);
        o.add(OutlierType.LS);
        RG1.setTransform(tr);
        RG1.setOutliers(o);
        RG2.setTransform(tr);
        RG2.setOutliers(o);
        RG2.setRegression(rwd);
        RG3.setTransform(tr);
        RG3.setOutliers(o);
        RG3.setUsingAutoModel(true);
        RG4.setTransform(tr);
        RG4.setOutliers(o);
        RG4.setRegression(rwd);
        RG4.setUsingAutoModel(true);
        RG5.setTransform(tr);
        RG5.setOutliers(o);
        RG5.setRegression(rtd);
        RG5.setUsingAutoModel(true);
    }

    public static enum Default {
        NONE,
        RG0,
        RG1,
        RG2,
        RG3,
        RG4,
        RG5;

    }
}

