/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo.spectrum;

import ec.tstoolkit.modelling.arima.tramo.spectrum.TPeaks;
import ec.tstoolkit.modelling.arima.tramo.spectrum.WinType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Arrays;

public class TuckeyPeaks {
    private TsData serie;
    private double[] Spect;
    private double[] SPeaks;
    private int nSPeaks;
    private double TDPeaks;

    public double[] getSPeaks() {
        return this.SPeaks;
    }

    public double[] getSpect() {
        return this.Spect;
    }

    public double getTDPeaks() {
        return this.TDPeaks;
    }

    public int getnSPeaks() {
        return this.nSPeaks;
    }

    public TuckeyPeaks(TsData targetS) {
        this.serie = targetS;
        this.nSPeaks = 0;
        this.TDPeaks = -1.0;
        this.ComputeTuckeyPeaks();
    }

    private void Tpeaks(int Win_Size) {
        double incHpi = 0.0;
        double incHmid = 0.0;
        double incHtd = 0.0;
        double incH = 0.0;
        int indTD = 0;
        int indPI = 0;
        int indSmidLen = 0;
        int prob = 2;
        if (prob == 1) {
            switch (Win_Size) {
                case 112: {
                    incHpi = 5.51;
                    incHtd = incHmid = 3.86;
                    break;
                }
                case 79: {
                    incHpi = 9.1;
                    incHtd = incHmid = 3.86;
                    break;
                }
                default: {
                    incHpi = 4.08;
                    incHmid = 8.82;
                    incHtd = 3.86;
                    break;
                }
            }
        } else {
            switch (Win_Size) {
                case 112: {
                    incHpi = 3.67;
                    incHtd = incHmid = 2.7;
                    break;
                }
                case 79: {
                    incHpi = 4.45;
                    incHtd = incHmid = 2.7;
                    break;
                }
                default: {
                    incHpi = 4.36;
                    incHtd = incHmid = 2.7;
                }
            }
        }
        int[] indSmid = new int[5];
        block8 : switch (Win_Size) {
            case 112: {
                indSmid[0] = 10;
                indSmid[1] = 20;
                indSmid[2] = 29;
                indSmid[3] = 38;
                indSmid[4] = 48;
                indSmidLen = 5;
                indTD = 40;
                indPI = 57;
                break;
            }
            case 79: {
                indSmid[0] = 8;
                indSmid[1] = 14;
                indSmid[2] = 21;
                indSmid[3] = 27;
                indSmid[4] = 34;
                indSmidLen = 5;
                indTD = 29;
                indPI = 40;
                break;
            }
            default: {
                indTD = -1;
                indPI = 22;
                indSmidLen = 0;
                switch (this.serie.getFrequency()) {
                    case BiMonthly: {
                        indSmid[0] = 8;
                        indSmid[1] = 15;
                        indSmidLen = 2;
                        break block8;
                    }
                    case Quarterly: {
                        indTD = 14;
                        indSmid[0] = 12;
                        indSmidLen = 1;
                        break block8;
                    }
                    case QuadriMonthly: {
                        indPI = -1;
                        indSmid[1] = 15;
                        indSmidLen = 1;
                        break block8;
                    }
                    case Yearly: {
                        indPI = -1;
                    }
                }
            }
        }
        this.nSPeaks = -1;
        this.TDPeaks = -1.0;
        if (indTD > 0 && (incH = 2.0 * this.Spect[indTD - 1] / (this.Spect[indTD] + this.Spect[indTD - 2])) > incHtd) {
            this.TDPeaks = incH;
        }
        for (int i = 0; i < indSmidLen; ++i) {
            incH = 2.0 * this.Spect[indSmid[i] - 1] / (this.Spect[indSmid[i]] + this.Spect[indSmid[i] - 2]);
            if (!(incH > incHmid)) continue;
            ++this.nSPeaks;
            this.SPeaks[this.nSPeaks] = indSmid[i] - 1;
        }
        if (indPI > 0 && (incH = this.Spect[indPI - 1] / this.Spect[indPI - 2]) > incHpi) {
            ++this.nSPeaks;
            this.SPeaks[this.nSPeaks] = indPI;
        }
    }

    private void ComputeTuckeyPeaks() {
        int Win_Size = 0;
        if (this.serie.getFrequency() != TsFrequency.Monthly && this.serie.getLength() >= 60) {
            Win_Size = 44;
        } else if (this.serie.getFrequency() == TsFrequency.Monthly && this.serie.getLength() >= 120) {
            Win_Size = 112;
        } else if (this.serie.getFrequency() == TsFrequency.Monthly && this.serie.getLength() >= 80) {
            Win_Size = 79;
        } else {
            Win_Size = -1;
            this.Spect = null;
            this.SPeaks = null;
            this.nSPeaks = 0;
            this.TDPeaks = -1.0;
            return;
        }
        this.Spect = new double[60];
        double[] window = TPeaks.getWindow(WinType.Tukey, Win_Size);
        TPeaks.covWind(this.serie, this.Spect, window);
        this.SPeaks = new double[6];
        Arrays.fill(this.SPeaks, 0.0);
        this.Tpeaks(Win_Size);
    }
}

