/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.timeseries.simplets.TsData;

public class DifferencingResults {
    private final TsData original;
    private final TsData differenced;
    private final boolean mean;

    private static boolean checkStationarity(double[] data, int ifreq) {
        if (ifreq <= 4) {
            double var = DescriptiveStatistics.cov(0, data);
            for (int i = 0; i < ifreq; ++i) {
                if (!(DescriptiveStatistics.cov(i + 1, data) / var <= 0.2)) continue;
                return true;
            }
        } else {
            if (DescriptiveStatistics.cov(ifreq, data) <= 0.0) {
                return true;
            }
            for (int i = 0; i < 4; ++i) {
                if (!(DescriptiveStatistics.cov(i + 1, data) <= 0.0)) continue;
                return true;
            }
        }
        return false;
    }

    public static DifferencingResults create(TsData input, int delta, boolean mean) {
        int ifreq = input.getFrequency().intValue();
        if (delta < 0) {
            TsData del = DifferencingResults.diff(input, 1, true);
            if (!DifferencingResults.checkStationarity(del.internalStorage(), ifreq)) {
                del = DifferencingResults.diff(del, 1, true);
            }
            return new DifferencingResults(input, del, true);
        }
        return new DifferencingResults(input, DifferencingResults.diff(input, delta, mean), mean);
    }

    private static TsData diff(TsData s, int delta, boolean mean) {
        TsData del = s.delta(1, delta);
        if (mean) {
            DescriptiveStatistics stats = new DescriptiveStatistics(del);
            del.apply(x -> x - stats.getAverage());
        }
        return del;
    }

    public DifferencingResults(TsData orig, TsData diff, boolean mean) {
        this.original = orig;
        this.differenced = diff;
        this.mean = mean;
    }

    public int getDifferencingOrder() {
        return this.original.getLength() - this.differenced.getLength();
    }

    public TsData getRestrictedOriginal() {
        return this.original.fittoDomain(this.differenced.getDomain());
    }

    public TsData getOriginal() {
        return this.original;
    }

    public TsData getDifferenced() {
        return this.differenced;
    }

    public boolean isMean() {
        return this.mean;
    }
}

