/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.utilities;

import ec.tstoolkit.utilities.INameValidator;

public class DefaultNameValidator
implements INameValidator {
    private final CharSequence ex;
    private String msg;
    private static final String EMPTY_ERROR = "The name can't be empty";
    private static final String WS_ERROR = "The name can't contain leading or trailing ws";

    public DefaultNameValidator(CharSequence ex) {
        this.ex = ex;
    }

    private String error(char c) {
        StringBuilder builder = new StringBuilder();
        builder.append("The name can't contain '").append(c).append('\'');
        return builder.toString();
    }

    @Override
    public boolean accept(String name) {
        this.msg = null;
        if (name == null || name.isEmpty()) {
            this.msg = EMPTY_ERROR;
            return false;
        }
        if (Character.isWhitespace(name.charAt(0)) || Character.isWhitespace(name.charAt(name.length() - 1))) {
            this.msg = WS_ERROR;
            return false;
        }
        for (int i = 0; i < this.ex.length(); ++i) {
            char c = this.ex.charAt(i);
            if (name.indexOf(c) < 0) continue;
            this.msg = this.error(c);
            return false;
        }
        return true;
    }

    @Override
    public String getLastError() {
        return this.msg;
    }
}

