/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo.spectrum;

import ec.tstoolkit.modelling.arima.tramo.spectrum.Peaks;
import ec.tstoolkit.modelling.arima.tramo.spectrum.WinType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Arrays;

public class TPeaks {
    private double[] Spect;
    private double TDPeaks;
    private double[] SPeaks;
    private int nSPeaks;
    private TsData serie;

    public double[] getSPeaks() {
        return this.SPeaks;
    }

    public double[] getSpect() {
        return this.Spect;
    }

    public double getTDPeaks() {
        return this.TDPeaks;
    }

    public int getnSPeaks() {
        return this.nSPeaks;
    }

    public TPeaks(TsData targetS) {
        this.serie = targetS;
        this.ComputeTPeaks();
    }

    private static double parzen(int idx, int size) {
        double tmp = (double)idx / (double)size;
        if (idx <= size / 2) {
            return 1.0 - 6.0 * Math.pow(tmp, 2.0) + 6.0 * Math.pow(tmp, 3.0);
        }
        return 2.0 * Math.pow(1.0 - tmp, 3.0);
    }

    public static double[] getWindow(WinType type, int winSize) {
        double[] window = new double[winSize];
        switch (type) {
            case Welch: {
                for (int i = 0; i < winSize; ++i) {
                    window[i] = 1.0 - (double)i / (double)winSize * ((double)i / (double)winSize);
                }
                break;
            }
            case Tukey: {
                for (int i = 0; i < winSize; ++i) {
                    window[i] = 0.5 * (1.0 + Math.cos(Math.PI * (double)i / (double)winSize));
                }
                break;
            }
            case Bartlett: {
                for (int i = 0; i < winSize; ++i) {
                    window[i] = 1.0 - (double)i / (double)winSize;
                }
                break;
            }
            case Hamming: {
                for (int i = 0; i < winSize; ++i) {
                    window[i] = 0.54 + 0.46 * Math.cos(Math.PI * (double)i / (double)winSize);
                }
                break;
            }
            case Parzen: {
                for (int i = 0; i < winSize; ++i) {
                    window[i] = TPeaks.parzen(i, winSize);
                }
                break;
            }
            case Square: {
                for (int i = 0; i < winSize; ++i) {
                    window[i] = 1.0;
                }
                break;
            }
        }
        return window;
    }

    public static void covWind(TsData ser, double[] spect, double[] window) {
        int i;
        int Win_Size = window.length;
        double[] Cxx = new double[Win_Size + 1];
        Peaks.crosco(ser, ser, Cxx);
        Arrays.fill(spect, 0.0);
        for (i = 0; i < Win_Size; ++i) {
            spect[0] = spect[0] + Cxx[i] * window[i];
        }
        for (i = 1; i <= Win_Size / 2 + 1; ++i) {
            spect[i] = Cxx[0] * window[0];
            for (int j = 1; j < Win_Size; ++j) {
                int n = i;
                spect[n] = spect[n] + 2.0 * Cxx[j] * window[j] * Math.cos(Math.PI * 2 * (double)j * (double)i / (double)Win_Size);
            }
        }
    }

    private double[] dfPeaks(int Win_Size) {
        int Nz = this.serie.getLength();
        double[] retVal = new double[]{0.0, 0.0, 0.0, 0.0};
        if (Win_Size == 112) {
            double[][] df = new double[][]{{0.5463, 2.9303, 2.2042}, {1.1329, 7.6924, 10.8795}, {-0.3492, 1.533, 2.7696}, {0.9829, 3.8217, 6.9345}};
            double n100 = (double)Nz / 100.0;
            double n_100 = 100.0 / (double)Nz;
            retVal[0] = df[0][0] + df[0][1] * n100 + df[0][2] * n_100;
            retVal[1] = df[1][0] + df[1][1] * n100 + df[1][2] * n_100;
            retVal[2] = df[2][0] + df[2][1] * n100 + df[2][2] * n_100;
            retVal[3] = df[3][0] + df[3][1] * n100 + df[3][2] * n_100;
        } else if (Win_Size == 44) {
            double n100 = (double)Nz / 100.0;
            double n_100 = 100.0 / (double)Nz;
            double[][] df = new double[][]{{1.3779, 7.262, 0.3725}, {3.1495, 18.0654, 3.5564}, {0.2504, 3.6616, 0.7929}, {0.504, 9.7201, 3.0605}};
            retVal[0] = df[0][0] + df[0][1] * n100 + df[0][2] * n_100;
            retVal[1] = df[1][0] + df[1][1] * n100 + df[1][2] * n_100;
            retVal[2] = df[2][0] + df[2][1] * n100 + df[2][2] * n_100;
            retVal[3] = df[3][0] + df[3][1] * n100 + df[3][2] * n_100;
        } else if (Win_Size == 79) {
            retVal[0] = 6.35251;
            retVal[1] = 19.6308;
            retVal[2] = 2.29316;
            retVal[3] = 6.55412;
        }
        return retVal;
    }

    static double BetaCfra(double a, double b, double x) {
        double d = 1.0 - (a + b) * x / (a + 1.0);
        if (Math.abs(d) < Double.MIN_VALUE) {
            d = Double.MAX_VALUE;
        }
        d = 1.0 / d;
        double c = 1.0;
        double f = d;
        for (int m = 1; m <= 1000; ++m) {
            double m2 = 2.0 * (double)m;
            double aa = (double)m * (b - (double)m) * x / ((a - 1.0 + m2) * (a + m2));
            if (Math.abs(d = 1.0 + aa * d) < Double.MIN_VALUE) {
                d = Double.MAX_VALUE;
            }
            d = 1.0 / d;
            if (Math.abs(c = 1.0 + aa / c) < Double.MIN_VALUE) {
                c = Double.MIN_VALUE;
            }
            f = f * d * c;
            aa = -(a + (double)m) * (a + b + (double)m) * x / ((a + m2) * (a + 1.0 + m2));
            if (Math.abs(d = 1.0 + aa * d) < Double.MIN_VALUE) {
                d = Double.MIN_VALUE;
            }
            d = 1.0 / d;
            if (Math.abs(c = 1.0 + aa / c) < Double.MIN_VALUE) {
                c = Double.MIN_VALUE;
            }
            double del = d * c;
            f = f * d * c;
            if (!(Math.abs(del - 1.0) < 1.0E-7)) continue;
            return f;
        }
        return f;
    }

    static double LogGamma(double a) {
        double[] c = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double y = a;
        double tmp = a + 5.5;
        tmp = (a + 0.5) * Math.log(tmp) - tmp;
        double sum = 1.000000000190015;
        for (int i = 0; i < 6; ++i) {
            sum += c[i] / (y += 1.0);
        }
        return tmp + Math.log(2.5066282746310007 * sum / a);
    }

    static double BetaInc(double x, double a, double b) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        double bt = Math.exp(TPeaks.LogGamma(a + b) - TPeaks.LogGamma(a) - TPeaks.LogGamma(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return bt * TPeaks.BetaCfra(a, b, x) / a;
        }
        return 1.0 - bt * TPeaks.BetaCfra(b, a, 1.0 - x) / b;
    }

    public static double Fcdf(double F2, double x, double y) {
        return 1.0 - TPeaks.BetaInc(y / (y + x * F2), y / 2.0, x / 2.0);
    }

    private void Tpeaks2(int Win_Size) {
        int indTD = 0;
        int indPI = 0;
        double[] retVal = this.dfPeaks(Win_Size);
        int[] indSmid = new int[5];
        int indSmidLen = 0;
        Arrays.fill(indSmid, 0);
        block0 : switch (Win_Size) {
            case 112: {
                indSmid[0] = 10;
                indSmid[1] = 20;
                indSmid[2] = 29;
                indSmid[3] = 38;
                indSmid[4] = 48;
                indSmidLen = 5;
                indTD = 40;
                indPI = 57;
                break;
            }
            case 79: {
                indSmid[0] = 8;
                indSmid[1] = 14;
                indSmid[2] = 21;
                indSmid[3] = 27;
                indSmid[4] = 34;
                indTD = 29;
                indPI = 40;
                indSmidLen = 5;
                break;
            }
            default: {
                indTD = -1;
                indPI = 22;
                switch (this.serie.getFrequency()) {
                    case HalfYearly: {
                        indSmid[0] = 0;
                        indSmid[1] = 15;
                        indSmidLen = 2;
                        break block0;
                    }
                    case Quarterly: {
                        indTD = 14;
                        indSmid[0] = 12;
                        indSmidLen = 1;
                        break block0;
                    }
                    case QuadriMonthly: {
                        indPI = -1;
                        indSmid[0] = 15;
                        indSmidLen = 1;
                        break block0;
                    }
                    case Yearly: {
                        indPI = -1;
                    }
                }
            }
        }
        if (indTD > 0) {
            double incH = 2.0 * this.Spect[indTD - 1] / (this.Spect[indTD] + this.Spect[indTD - 2]);
            this.TDPeaks = TPeaks.Fcdf(incH, retVal[0], retVal[1]);
        }
        this.nSPeaks = indSmidLen;
        for (int i = 0; i < indSmidLen; ++i) {
            double incH = 2.0 * this.Spect[indSmid[i] - 1];
            this.SPeaks[i] = TPeaks.Fcdf(incH /= this.Spect[indSmid[i]] + this.Spect[indSmid[i] - 2], retVal[0], retVal[1]);
        }
        if (indPI > 0) {
            double incH = this.Spect[indPI - 1] / this.Spect[indPI - 2];
            this.SPeaks[this.serie.getFrequency().intValue() / 2 - 1] = TPeaks.Fcdf(incH, retVal[2], retVal[3]);
        }
    }

    private void ComputeTPeaks() {
        int Win_Size = 0;
        if (this.serie.getFrequency() != TsFrequency.Monthly && this.serie.getLength() >= 60) {
            Win_Size = 44;
        } else if (this.serie.getFrequency() == TsFrequency.Monthly && this.serie.getLength() >= 120) {
            Win_Size = 112;
        } else if (this.serie.getFrequency() == TsFrequency.Monthly && this.serie.getLength() >= 80) {
            Win_Size = 79;
        } else {
            Win_Size = -1;
            this.Spect = null;
            this.SPeaks = null;
            this.nSPeaks = 0;
            this.TDPeaks = 0.0;
            return;
        }
        this.Spect = new double[60];
        double[] window = TPeaks.getWindow(WinType.Tukey, Win_Size);
        TPeaks.covWind(this.serie, this.Spect, window);
        this.TDPeaks = 0.0;
        this.SPeaks = new double[6];
        Arrays.fill(this.SPeaks, 0.0);
        this.Tpeaks2(Win_Size);
    }
}

