/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.special;

import ec.satoolkit.IDefaultSeriesDecomposer;
import ec.satoolkit.IPreprocessingFilter;
import ec.satoolkit.special.StmResults;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.structural.BsmMonitor;
import ec.tstoolkit.structural.BsmSpecification;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;

public class StmDecomposer
implements IDefaultSeriesDecomposer<StmResults> {
    private BsmSpecification spec_;
    private StmResults results_;

    public StmDecomposer(BsmSpecification spec) {
        this.spec_ = spec;
    }

    @Override
    public boolean decompose(PreprocessingModel model, IPreprocessingFilter filter) {
        Matrix M;
        TsData y = filter.getCorrectedSeries(true);
        BsmMonitor monitor = new BsmMonitor();
        monitor.setSpecification(this.spec_);
        RegArimaModel<SarimaModel> regArima = model.estimation.getRegArima();
        DataBlock ry = regArima.getY();
        double[] yo = new double[ry.getLength()];
        ry.copyTo(yo, 0);
        int[] missings = regArima.getMissings();
        if (missings != null) {
            for (int i = 0; i < missings.length; ++i) {
                yo[i] = Double.NaN;
            }
        }
        if (regArima.getXCount() > 0) {
            M = new Matrix(yo.length, regArima.getXCount());
            for (int i = 0; i < M.getColumnsCount(); ++i) {
                M.column(i).copy(regArima.X(i));
            }
        } else {
            M = null;
        }
        if (!monitor.process(yo, M == null ? null : M.subMatrix(), y.getFrequency().intValue())) {
            return false;
        }
        this.results_ = new StmResults(y, model.description.buildRegressionVariables(), monitor, model.description.getTransformation() == DefaultTransformationType.Log);
        return true;
    }

    @Override
    public boolean decompose(TsData y) {
        BsmMonitor monitor = new BsmMonitor();
        monitor.setSpecification(this.spec_);
        if (!monitor.process(y.internalStorage(), y.getFrequency().intValue())) {
            return false;
        }
        this.results_ = new StmResults(y, new TsVariableList(), monitor, false);
        return true;
    }

    @Override
    public StmResults getDecomposition() {
        return this.results_;
    }
}

