% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glcm.R
\encoding{UTF-8}
\name{glcm}
\alias{glcm}
\title{Creates gray-level co-occurrence matrix of RIA image}
\usage{
glcm(RIA_data_in, off_right = 1, off_down = 0, off_z = 0,
  symmetric = TRUE, normalize = TRUE, use_type = "single",
  use_orig = FALSE, use_slot = NULL, save_name = NULL,
  verbose_in = TRUE)
}
\arguments{
\item{RIA_data_in}{\emph{RIA_image}.}

\item{off_right}{integer, indicating the number of voxels to look to the right.
Negative values indicate to the left.}

\item{off_down}{integer, indicating the number of voxels to look down.
Negative values indicate up.}

\item{off_z}{integer, indicating the number of voxels to look in cross plane.}

\item{symmetric}{logical, indicating whether to create a symmetric glcm
by also calculating the glcm in the opposite direction (-1*off_right; -1*off_down;
-1*off_z), and add it to the glcm}

\item{normalize}{logical, indicating whether to change glcm elements to relaive frequencies.}

\item{use_type}{string, can be \emph{"single"} which runs the function on a single image,
which is determined using \emph{"use_orig"} or \emph{"use_slot"}. \emph{"discretized"}
takes all datasets in the \emph{RIA_image$discretized} slot and runs the analysis on them.}

\item{use_orig}{logical, indicating to use image present in \emph{RIA_data$orig}.
If FALSE, the modified image will be used stored in \emph{RIA_data$modif}.}

\item{use_slot}{string, name of slot where data wished to be used is. Use if the desired image
is not in the \emph{data$orig} or \emph{data$modif} slot of the \emph{RIA_image}. For example,
if the desired dataset is in \emph{RIA_image$discretized$ep_4}, then \emph{use_slot} should be
\emph{discretized$ep_4}. The results are automatically saved. If the results are not saved to
the desired slot, then please use \emph{save_name} parameter.}

\item{save_name}{string, indicating the name of subslot of \emph{$glcm} to save results to.
If left empty, then it will be automatically determined by RIA.}

\item{verbose_in}{logical indicating whether to print detailed information.
Most prints can also be suppressed using the \code{\link{suppressMessages}} function.}
}
\value{
\emph{RIA_image} containing the GLCM.
}
\description{
Creates gray-level co-occurrence matrix (GLCM) from \emph{RIA_image}.
GLCM assesses the spatial relation of voxels to each other. By default the \emph{$modif}
image will be used to calculate GLCMs. If \emph{use_slot} is given, then the data
present in \emph{RIA_image$use_slot} will be used for calculations.
Results will be saved into the \emph{glcm} slot. The name of the subslot is determined
by the supplied string in \emph{save_name}, or is automatically generated by RIA.
}
\examples{
\dontrun{
#Discretize loaded image and then calculate GLCM matrix of RIA_image$modif
RIA_image <- discretize(RIA_image, bins_in = c(4, 8), equal_prob = TRUE,
use_orig = TRUE, write_orig = FALSE)
RIA_image <- glcm(RIA_image, use_orig = FALSE, verbose_in = TRUE)

#Use use_slot parameter to set which image to use
RIA_image <- glcm(RIA_image, use_orig = FALSE, use_slot = "discretized$ep_4",
off_right = 2, off_down = -1, off_z = 0)

#Batch calculation of GLCM matrices on all discretized images
RIA_image <- glcm(RIA_image, use_type = "discretized",
off_right = 1, off_down = -1, off_z = 0)
}

}
\references{
Robert M. HARALICK et al. 
Textural Features for Image Classification.
IEEE Transactions on Systems, Man, and Cybernetics. 1973; SMC-3:610-621.
DOI: 10.1109/TSMC.1973.4309314
\url{https://ieeexplore.ieee.org/document/4309314/}

Márton KOLOSSVÁRY et al.
Radiomic Features Are Superior to Conventional Quantitative Computed Tomographic
Metrics to Identify Coronary Plaques With Napkin-Ring Sign
Circulation: Cardiovascular Imaging (2017).
DOI: 10.1161/circimaging.117.006843
\url{https://pubmed.ncbi.nlm.nih.gov/29233836/}

Márton KOLOSSVÁRY et al.
Cardiac Computed Tomography Radiomics: A Comprehensive Review on Radiomic Techniques.
Journal of Thoracic Imaging (2018).
DOI: 10.1097/RTI.0000000000000268
\url{https://pubmed.ncbi.nlm.nih.gov/28346329/}
}
