\name{SurrogateTest}
\alias{SurrogateTest}
\title{Surrogate data testing}
\usage{
  SurrogateTest(HRVData,
    indexNonLinearAnalysis = length(HRVData$NonLinearAnalysis),
    significance = 0.05, doPlot = TRUE, useFunction, ...)
}
\arguments{
  \item{HRVData}{Structure containing the RR time series.}

  \item{indexNonLinearAnalysis}{Reference to the data
  structure that will contain the nonlinear analysis}

  \item{significance}{Significance of the test}

  \item{doPlot}{Logical value. If TRUE, a graphical
  representation of the statistic value for both surrogates
  and original data is shown.}

  \item{useFunction}{The function that computes the
  discriminating statistic that shall be used for testing.}

  \item{...}{Additional arguments for the
  \emph{useFunction} function.}
}
\value{
  A \emph{HRVData} structure containing a
  \emph{SurrogateTest} field storing the statistics
  computed for the set (\emph{surrogates.statistics} field)
  and the RR time series (\emph{data.statistic field}). The
  \emph{SurrogateTest} list is stored under the
  \emph{NonLinearAnalysis} structure.
}
\description{
  Surrogate data testing
}
\details{
  This function tests the null hypothesis (H0) stating that
  the series describes a linear process. The test is
  performed by generating several surrogate data according
  to H0 and comparing the values of a discriminating
  statistic between both original data and the surrogate
  data. If the value of the statistic is significantly
  different for the original series than for the surrogate
  set, the null hypothesis is rejected and nonlinearity
  assumed.  The surrogate data is generated by using a
  phase randomization procedure.
}
\author{
  Constantino A. Garcia
}
\references{
  SCHREIBER, Thomas; SCHMITZ, Andreas. Surrogate time
  series. Physica D: Nonlinear Phenomena, 2000, vol. 142,
  no 3, p. 346-382.
}

